/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.block.entity;

import cz.lukesmith.automaticsorter.block.custom.FilterBlock;
import cz.lukesmith.automaticsorter.block.custom.PipeBlock;
import cz.lukesmith.automaticsorter.block.custom.SorterControllerBlock;
import cz.lukesmith.automaticsorter.block.entity.FilterBlockEntity;
import cz.lukesmith.automaticsorter.block.entity.ImplementedInventory;
import cz.lukesmith.automaticsorter.block.entity.ModBlockEntities;
import cz.lukesmith.automaticsorter.config.ModConfig;
import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.IInventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.NoInventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryUtils.MainInventoryUtil;
import cz.lukesmith.automaticsorter.item.ModItems;
import cz.lukesmith.automaticsorter.screen.SorterControllerScreenHandler;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1262;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class SorterControllerBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<class_2338>,
ImplementedInventory {
    private int ticker = 0;
    private static final int MAX_TICKER = 5;
    private double overflow = 0.0;
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)1, (Object)class_1799.field_8037);

    public SorterControllerBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.SORTER_CONTROLLER_BLOCK_ENTITY, pos, state);
    }

    public static SorterControllerBlockEntity create(class_2338 pos, class_2680 state) {
        return new SorterControllerBlockEntity(pos, state);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        class_1262.method_5426((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        class_1262.method_5429((class_2487)nbt, this.inventory, (class_7225.class_7874)registryLookup);
    }

    public class_2338 getScreenOpeningData(class_3222 serverPlayerEntity) {
        return this.field_11867;
    }

    public class_2561 method_5476() {
        return class_2561.method_43471((String)"block.automaticsorter.sorter_controller");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new SorterControllerScreenHandler(syncId, playerInventory, this.field_11867);
    }

    private static int tryWhitelistMode(IInventoryAdapter rootInventoryAdapter, IInventoryAdapter chestInventoryAdapter, IInventoryAdapter filterInventoryAdapter, int maxTransfer) {
        if (rootInventoryAdapter.isEmpty()) {
            return maxTransfer;
        }
        int transferLeft = maxTransfer;
        ArrayList<class_1799> stacks = rootInventoryAdapter.getAllStacks();
        int stackSize = stacks.size();
        for (int i = 0; i < stackSize; ++i) {
            class_1799 containItemStack;
            class_1799 rootInventoryItemStack = stacks.get(i);
            if (rootInventoryItemStack.method_7960() || (containItemStack = filterInventoryAdapter.containsItem(rootInventoryItemStack)).method_7960()) continue;
            int transferedInStack = chestInventoryAdapter.addItem(rootInventoryItemStack, transferLeft);
            transferLeft -= transferedInStack;
            if (transferedInStack <= 0) continue;
            rootInventoryAdapter.removeItem(i, transferedInStack);
            if (transferLeft > 0) continue;
            return 0;
        }
        return transferLeft;
    }

    private static int tryInInventoryMode(IInventoryAdapter rootInventoryAdapter, IInventoryAdapter chestInventoryAdapter, int maxTransfer) {
        if (rootInventoryAdapter.isEmpty()) {
            return maxTransfer;
        }
        int transferLeft = maxTransfer;
        ArrayList<class_1799> stacks = rootInventoryAdapter.getAllStacks();
        int stackSize = stacks.size();
        for (int i = 0; i < stackSize; ++i) {
            class_1799 containItemStack;
            class_1799 rootInventoryItemStack = stacks.get(i);
            if (rootInventoryItemStack.method_7960() || (containItemStack = chestInventoryAdapter.containsItem(rootInventoryItemStack)).method_7960()) continue;
            int transferedInStack = chestInventoryAdapter.addItem(rootInventoryItemStack, transferLeft);
            transferLeft -= transferedInStack;
            if (transferedInStack <= 0) continue;
            rootInventoryAdapter.removeItem(i, transferedInStack);
            if (transferLeft > 0) continue;
            return 0;
        }
        return transferLeft;
    }

    private static int tryRejectsMode(IInventoryAdapter rootInventoryAdapter, IInventoryAdapter chestInventoryAdapter, int maxTransfer) {
        if (rootInventoryAdapter.isEmpty()) {
            return maxTransfer;
        }
        int transferLeft = maxTransfer;
        ArrayList<class_1799> stacks = rootInventoryAdapter.getAllStacks();
        int stackSize = stacks.size();
        for (int i = 0; i < stackSize; ++i) {
            class_1799 rootInventoryItemStack = stacks.get(i);
            if (rootInventoryItemStack.method_7960()) continue;
            int transferedInStack = chestInventoryAdapter.addItem(rootInventoryItemStack, transferLeft);
            transferLeft -= transferedInStack;
            if (transferedInStack <= 0) continue;
            rootInventoryAdapter.removeItem(i, transferedInStack);
            if (transferLeft > 0) continue;
            return 0;
        }
        return transferLeft;
    }

    private static int tryToTransferItem(class_1937 world, FilterBlockEntity filterBlockEntity, class_2338 filterPos, IInventoryAdapter rootInventoryAdapter, int maxTransfer) {
        class_2350 filterDirection = (class_2350)world.method_8320(filterPos).method_11654(FilterBlock.FACING);
        class_2338 chestPos = filterPos.method_10093(filterDirection);
        IInventoryAdapter chestInventoryAdapter = MainInventoryUtil.getInventoryAdapter(world, chestPos);
        if (chestInventoryAdapter instanceof NoInventoryAdapter) {
            return maxTransfer;
        }
        int filterType = filterBlockEntity.getFilterType();
        return switch (FilterBlockEntity.FilterTypeEnum.fromValue(filterType)) {
            case FilterBlockEntity.FilterTypeEnum.WHITELIST -> {
                IInventoryAdapter filterInventoryAdapter = MainInventoryUtil.getInventoryAdapter(world, filterPos);
                yield SorterControllerBlockEntity.tryWhitelistMode(rootInventoryAdapter, chestInventoryAdapter, filterInventoryAdapter, maxTransfer);
            }
            case FilterBlockEntity.FilterTypeEnum.IN_INVENTORY -> SorterControllerBlockEntity.tryInInventoryMode(rootInventoryAdapter, chestInventoryAdapter, maxTransfer);
            case FilterBlockEntity.FilterTypeEnum.REJECTS -> SorterControllerBlockEntity.tryRejectsMode(rootInventoryAdapter, chestInventoryAdapter, maxTransfer);
            default -> maxTransfer;
        };
    }

    private int getAmplifierCount() {
        if (!this.method_5438(0).method_7960() && this.method_5438(0).method_7909().equals(ModItems.SORTER_AMPLIFIER)) {
            return this.method_5438(0).method_7947();
        }
        return 0;
    }

    public double getSpeedPerSecond() {
        if (ModConfig.get().instantSort) {
            return Double.MAX_VALUE;
        }
        double baseSpeed = ModConfig.get().baseSortingSpeed;
        double speedBoost = (double)this.getAmplifierCount() * ModConfig.get().baseSpeedBoostPerUpgrade;
        return baseSpeed + speedBoost;
    }

    public double getSpeedPerTick() {
        return this.getSpeedPerSecond() / 20.0;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        if (world.field_9236) {
            return;
        }
        if (this.ticker > 0) {
            --this.ticker;
            return;
        }
        double speed = this.getSpeedPerTick() * 5.0;
        int maxTransfer = (int)Math.floor(speed + this.overflow);
        this.overflow = speed + this.overflow - (double)maxTransfer;
        if (ModConfig.get().instantSort && this.overflow != 0.0) {
            this.overflow = 0.0;
        }
        HashSet<class_2338> visited = new HashSet<class_2338>();
        class_2350 facing = (class_2350)world.method_8320(pos).method_11654(SorterControllerBlock.FACING);
        class_2338 nextPos = pos.method_10093(facing.method_10153());
        if (world.method_8320(nextPos).method_26204() instanceof PipeBlock) {
            LinkedList<class_2338> queue = new LinkedList<class_2338>();
            queue.add(nextPos);
            IInventoryAdapter rootInventoryAdapter = MainInventoryUtil.getInventoryAdapter(world, pos.method_10093(facing));
            boolean noInventoryRootChest = rootInventoryAdapter instanceof NoInventoryAdapter;
            int itemsLeftToTransfer = maxTransfer;
            ArrayList<FilterBlockEntity> rejectedFilters = new ArrayList<FilterBlockEntity>();
            block0: while (!queue.isEmpty() && itemsLeftToTransfer >= 0 && !noInventoryRootChest) {
                class_2338 currentPos = (class_2338)queue.poll();
                if (visited.contains(currentPos)) continue;
                visited.add(currentPos);
                for (class_2350 direction : class_2350.values()) {
                    class_2586 filterEntity;
                    class_2338 neighborPos = currentPos.method_10093(direction);
                    class_2248 block = world.method_8320(neighborPos).method_26204();
                    if (block instanceof PipeBlock) {
                        queue.add(neighborPos);
                        continue;
                    }
                    if (!(block instanceof FilterBlock) || !((filterEntity = world.method_8321(neighborPos)) instanceof FilterBlockEntity)) continue;
                    FilterBlockEntity filterBlockEntity = (FilterBlockEntity)filterEntity;
                    class_2350 filterFacing = (class_2350)world.method_8320(neighborPos).method_11654(FilterBlock.FACING);
                    if (direction != filterFacing) continue;
                    if (filterBlockEntity.getFilterType() == FilterBlockEntity.FilterTypeEnum.REJECTS.getValue()) {
                        rejectedFilters.add(filterBlockEntity);
                        continue;
                    }
                    if ((itemsLeftToTransfer = SorterControllerBlockEntity.tryToTransferItem(world, filterBlockEntity, neighborPos, rootInventoryAdapter, itemsLeftToTransfer)) >= 0) continue block0;
                }
            }
            if (itemsLeftToTransfer >= 0) {
                FilterBlockEntity filterBlockEntity;
                Iterator iterator = rejectedFilters.iterator();
                while (iterator.hasNext() && (itemsLeftToTransfer = SorterControllerBlockEntity.tryToTransferItem(world, filterBlockEntity = (FilterBlockEntity)iterator.next(), filterBlockEntity.method_11016(), rootInventoryAdapter, itemsLeftToTransfer)) < 0) {
                }
            }
        }
        this.ticker = 5;
    }
}

