/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.command;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import cz.lukesmith.automaticsorter.AutomaticSorter;
import cz.lukesmith.automaticsorter.block.custom.FilterBlock;
import cz.lukesmith.automaticsorter.block.custom.SorterControllerBlock;
import cz.lukesmith.automaticsorter.block.entity.FilterBlockEntity;
import cz.lukesmith.automaticsorter.block.entity.SorterControllerBlockEntity;
import cz.lukesmith.automaticsorter.config.ModConfig;
import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.IInventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryUtils.MainInventoryUtil;
import cz.lukesmith.automaticsorter.network.ModConfigSyncPayload;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.class_8710;

public class ModCommands {
    private static final File EXPORT_FILE = new File("config/automatic_sorter_export.json");

    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"as_basespeed").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)Double.MAX_VALUE)).executes(ctx -> {
                double value;
                ModConfig.get().baseSortingSpeed = value = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value");
                ModConfig.save();
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"message.automaticsorter.basespeed_set", (Object[])new Object[]{value}), true);
                ModCommands.sendSyncConfigPacketToAllPlayers((CommandContext<class_2168>)ctx);
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"as_basespeedboostperupgrade").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)Double.MAX_VALUE)).executes(ctx -> {
                double value;
                ModConfig.get().baseSpeedBoostPerUpgrade = value = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"value");
                ModConfig.save();
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"message.automaticsorter.basespeedboost_set", (Object[])new Object[]{value}), true);
                ModCommands.sendSyncConfigPacketToAllPlayers((CommandContext<class_2168>)ctx);
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"as_instantsort").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
                boolean value;
                ModConfig.get().instantSort = value = BoolArgumentType.getBool((CommandContext)ctx, (String)"value");
                ModConfig.save();
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"message.automaticsorter.instantsort_set", (Object[])new Object[]{value ? "true" : "false"}), true);
                ModCommands.sendSyncConfigPacketToAllPlayers((CommandContext<class_2168>)ctx);
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"as_exportModBlocks").requires(src -> src.method_9259(2))).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
                class_2168 source = (class_2168)ctx.getSource();
                class_3218 world = source.method_9225();
                class_2338 origin = source.method_44023().method_24515();
                int radius = Math.min(IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), 1024);
                JsonArray blocks = new JsonArray();
                int objectsDetected = 0;
                for (int x = -radius; x <= radius; ++x) {
                    for (int y = -radius; y <= radius; ++y) {
                        for (int z = -radius; z <= radius; ++z) {
                            class_2338 pos = origin.method_10069(x, y, z);
                            class_2680 state = world.method_8320(pos);
                            class_2248 block = state.method_26204();
                            class_2960 id = class_7923.field_41175.method_10221((Object)block);
                            class_2586 blockEntity = world.method_8321(pos);
                            if (!id.method_12836().equals("automaticsorter")) continue;
                            JsonObject obj = new JsonObject();
                            obj.addProperty("x", (Number)x);
                            obj.addProperty("y", (Number)y);
                            obj.addProperty("z", (Number)z);
                            obj.addProperty("block", id.toString());
                            obj.addProperty("properties", state.toString());
                            if (blockEntity instanceof SorterControllerBlockEntity || blockEntity instanceof FilterBlockEntity) {
                                JsonArray inventory = new JsonArray();
                                class_1263 inv = (class_1263)blockEntity;
                                for (int i = 0; i < inv.method_5439(); ++i) {
                                    class_1799 stack = inv.method_5438(i);
                                    if (stack.method_7960()) continue;
                                    JsonObject itemObj = new JsonObject();
                                    itemObj.addProperty("slot", (Number)i);
                                    itemObj.addProperty("item", class_7923.field_41178.method_10221((Object)stack.method_7909()).toString());
                                    itemObj.addProperty("count", (Number)stack.method_7947());
                                    inventory.add((JsonElement)itemObj);
                                }
                                if (blockEntity instanceof FilterBlockEntity) {
                                    FilterBlockEntity filterBlockEntity = (FilterBlockEntity)blockEntity;
                                    obj.addProperty("filterType", (Number)filterBlockEntity.getFilterType());
                                }
                                obj.add("inventory", (JsonElement)inventory);
                                if (block instanceof SorterControllerBlock) {
                                    class_2350 direction = (class_2350)world.method_8320(pos).method_11654(SorterControllerBlock.FACING);
                                    pos = pos.method_10093(direction);
                                } else if (block instanceof FilterBlock) {
                                    pos = pos.method_10093((class_2350)world.method_8320(pos).method_11654(FilterBlock.FACING));
                                }
                                IInventoryAdapter inventoryAdapter = MainInventoryUtil.getInventoryAdapter((class_1937)world, pos);
                                JsonObject jsonIAdapter = new JsonObject();
                                state = world.method_8320(pos);
                                jsonIAdapter.addProperty("block", class_7923.field_41175.method_10221((Object)state.method_26204()).toString());
                                jsonIAdapter.addProperty("properties", state.toString());
                                JsonArray adapterInventory = new JsonArray();
                                for (int i = 0; i < inventoryAdapter.getAllStacks().size(); ++i) {
                                    class_1799 stack = inventoryAdapter.getAllStacks().get(i);
                                    if (stack.method_7960()) continue;
                                    JsonObject itemObj = new JsonObject();
                                    itemObj.addProperty("slot", (Number)i);
                                    itemObj.addProperty("item", class_7923.field_41178.method_10221((Object)stack.method_7909()).toString());
                                    itemObj.addProperty("count", (Number)stack.method_7947());
                                    adapterInventory.add((JsonElement)itemObj);
                                }
                                jsonIAdapter.add("inventory", (JsonElement)adapterInventory);
                                obj.add("inventoryAdapter", (JsonElement)jsonIAdapter);
                            }
                            blocks.add((JsonElement)obj);
                            ++objectsDetected;
                        }
                    }
                }
                JsonObject root = new JsonObject();
                root.add("blocks", (JsonElement)blocks);
                Path file = EXPORT_FILE.toPath();
                try {
                    Files.writeString(file, (CharSequence)root.toString(), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                int finalObjectsDetected = objectsDetected;
                source.method_9226(() -> class_2561.method_43469((String)"message.automaticsorter.objects_detected", (Object[])new Object[]{finalObjectsDetected}), false);
                return 1;
            })));
            if (AutomaticSorter.isDevEnvironment()) {
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"as_importModBlocks").requires(src -> src.method_9259(2))).executes(ctx -> {
                    class_2168 source = (class_2168)ctx.getSource();
                    class_3218 world = source.method_9225();
                    class_2338 origin = source.method_44023().method_24515();
                    Path file = EXPORT_FILE.toPath();
                    JsonObject root = null;
                    try {
                        root = JsonParser.parseString((String)Files.readString(file)).getAsJsonObject();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    JsonArray blocks = root.getAsJsonArray("blocks");
                    for (JsonElement el : blocks) {
                        class_2338 adapterPos;
                        JsonObject obj = el.getAsJsonObject();
                        int x = obj.get("x").getAsInt();
                        int y = obj.get("y").getAsInt();
                        int z = obj.get("z").getAsInt();
                        class_2338 pos = origin.method_10069(x, y, z);
                        class_2960 id = class_2960.method_60654((String)obj.get("block").getAsString());
                        class_2248 block = (class_2248)class_7923.field_41175.method_63535(id);
                        class_2680 state = ModCommands.parseBlockState(block, obj.get("properties").getAsString());
                        world.method_8501(pos, state);
                        class_2586 be = world.method_8321(pos);
                        if (be instanceof class_1263 && obj.has("inventory")) {
                            class_1263 inv = (class_1263)be;
                            JsonArray items = obj.getAsJsonArray("inventory");
                            int slot = 0;
                            for (JsonElement itemEl : items) {
                                JsonObject itemObj = itemEl.getAsJsonObject();
                                class_1799 stack = new class_1799((class_1935)class_7923.field_41178.method_63535(class_2960.method_60654((String)itemObj.get("item").getAsString())), itemObj.get("count").getAsInt());
                                if (slot >= inv.method_5439()) continue;
                                inv.method_5447(slot++, stack);
                            }
                        }
                        if (be instanceof FilterBlockEntity && obj.has("filterType")) {
                            ((FilterBlockEntity)be).setFilterType(obj.get("filterType").getAsInt());
                        }
                        if (!obj.has("inventoryAdapter")) continue;
                        JsonObject adapter = obj.getAsJsonObject("inventoryAdapter");
                        if (block instanceof SorterControllerBlock) {
                            direction = (class_2350)world.method_8320(pos).method_11654(SorterControllerBlock.FACING);
                            adapterPos = pos.method_10093(direction);
                        } else {
                            if (!(block instanceof FilterBlock)) continue;
                            direction = (class_2350)world.method_8320(pos).method_11654(FilterBlock.FACING);
                            adapterPos = pos.method_10093(direction);
                        }
                        class_2960 adapterId = class_2960.method_60654((String)adapter.get("block").getAsString());
                        class_2248 adapterBlock = (class_2248)class_7923.field_41175.method_63535(adapterId);
                        class_2680 adapterState = ModCommands.parseBlockState(adapterBlock, adapter.get("properties").getAsString());
                        world.method_8501(adapterPos, adapterState);
                        class_2586 adapterBe = world.method_8321(adapterPos);
                        if (!(adapterBe instanceof class_1263) || !adapter.has("inventory")) continue;
                        class_1263 inv = (class_1263)adapterBe;
                        JsonArray items = adapter.getAsJsonArray("inventory");
                        int slot = 0;
                        for (JsonElement itemEl : items) {
                            JsonObject itemObj = itemEl.getAsJsonObject();
                            class_1799 stack = new class_1799((class_1935)class_7923.field_41178.method_63535(class_2960.method_60654((String)itemObj.get("item").getAsString())), itemObj.get("count").getAsInt());
                            if (slot >= inv.method_5439()) continue;
                            inv.method_5447(slot++, stack);
                        }
                    }
                    source.method_9226(() -> class_2561.method_43470((String)"Import hotov!"), false);
                    return 1;
                }));
            }
        });
    }

    private static class_2680 parseBlockState(class_2248 block, String propertiesString) {
        class_2680 state = block.method_9564();
        int start = propertiesString.indexOf(91);
        int end = propertiesString.indexOf(93);
        if (start != -1 && end != -1 && end > start) {
            String[] pairs;
            String props = propertiesString.substring(start + 1, end);
            for (String pair : pairs = props.split(",")) {
                String[] kv = pair.split("=");
                if (kv.length != 2) continue;
                String key = kv[0].trim();
                String value = kv[1].trim();
                if (!state.method_28501().stream().anyMatch(p -> p.method_11899().equals(key))) continue;
                class_2769 property = state.method_28501().stream().filter(p -> p.method_11899().equals(key)).findFirst().get();
                if (property.method_11902() == Boolean.class) {
                    state = (class_2680)state.method_11657(property, (Comparable)Boolean.valueOf(Boolean.parseBoolean(value)));
                    continue;
                }
                if (property.method_11902() == class_2350.class) {
                    state = (class_2680)state.method_11657(property, (Comparable)class_2350.valueOf((String)value.toUpperCase()));
                    continue;
                }
                if (property.method_11902() != Integer.class) continue;
                state = (class_2680)state.method_11657(property, (Comparable)Integer.valueOf(Integer.parseInt(value)));
            }
        }
        return state;
    }

    private static void sendSyncConfigPacketToAllPlayers(CommandContext<class_2168> ctx) {
        ModConfig config = ModConfig.get();
        ModConfigSyncPayload payload = new ModConfigSyncPayload(config.baseSortingSpeed, config.baseSpeedBoostPerUpgrade, config.instantSort);
        for (class_3222 player : ((class_2168)ctx.getSource()).method_9211().method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)payload);
        }
    }
}

