/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.inventory.inventoryUtils;

import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.AssortedInventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.IInventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.NoInventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryUtils.IInventoryUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public class AssortedInventoryUtil
implements IInventoryUtil {
    private static final String MAIN_CLASSNANE = "com.grim3212.assorted.storage.common.block.blockentity.BaseStorageBlockEntity";
    public static final String STORAGE_HANDLER_CLASSNAME = "com.grim3212.assorted.lib.core.inventory.impl.ItemStackStorageHandler";

    @Override
    public IInventoryAdapter getInventoryAdapter(class_1937 world, class_2338 pos, class_2248 block, class_2586 blockEntity) {
        try {
            Class<?> itemStackStorageHandlerClass = Class.forName(STORAGE_HANDLER_CLASSNAME);
            Object itemStackStorageHandler = AssortedInventoryUtil.getAssortedStorageItemStackStorageHandler(blockEntity);
            if (itemStackStorageHandler == null) {
                return new NoInventoryAdapter();
            }
            Method getSlotsMethod = itemStackStorageHandlerClass.getMethod("getSlots", new Class[0]);
            int slots = (Integer)getSlotsMethod.invoke(itemStackStorageHandler, new Object[0]);
            Method getStackMethod = itemStackStorageHandlerClass.getMethod("getStackInSlot", Integer.TYPE);
            ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
            for (int i = 0; i < slots; ++i) {
                class_1799 itemStack = (class_1799)getStackMethod.invoke(itemStackStorageHandler, i);
                itemStacks.add(itemStack);
            }
            return new AssortedInventoryAdapter(itemStacks, blockEntity);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return new NoInventoryAdapter();
        }
    }

    @Override
    public boolean isRelatedStorage(class_2248 block, class_2586 blockEntity) {
        try {
            Class<?> chestBlockClass = Class.forName(MAIN_CLASSNANE);
            return chestBlockClass.isInstance(blockEntity);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static Object getAssortedStorageItemStackStorageHandler(class_2586 blockEntity) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> chestBlockClass = Class.forName(MAIN_CLASSNANE);
        if (chestBlockClass.isInstance(blockEntity)) {
            Object chestBlockEntity = chestBlockClass.cast(blockEntity);
            Method isLockedMethod = chestBlockClass.getMethod("isLocked", new Class[0]);
            boolean isLocked = (Boolean)isLockedMethod.invoke(chestBlockEntity, new Object[0]);
            if (isLocked) {
                return null;
            }
            Method getContainerMethod = chestBlockClass.getMethod("getStorageHandler", new Class[0]);
            Object lockedItemStackStorageHandler = getContainerMethod.invoke(chestBlockEntity, new Object[0]);
            Class<?> itemStackStorageHandlerClass = Class.forName(STORAGE_HANDLER_CLASSNAME);
            Class<?> fabricPlatformInvClass = Class.forName("com.grim3212.assorted.lib.inventory.FabricPlatformInventoryStorageHandlerUnsided");
            if (fabricPlatformInvClass.isInstance(lockedItemStackStorageHandler)) {
                Object fabricPlatformInventory = fabricPlatformInvClass.cast(lockedItemStackStorageHandler);
                Method getItemStorageHandlerMethod = fabricPlatformInvClass.getDeclaredMethod("getItemStorageHandler", class_2350.class);
                Object storageHandler = getItemStorageHandlerMethod.invoke(fabricPlatformInventory, new Object[]{null});
                return itemStackStorageHandlerClass.cast(storageHandler);
            }
        }
        throw new ClassNotFoundException("Class not found: com.grim3212.assorted.lib.core.inventory.impl.ItemStackStorageHandler");
    }
}

