/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.inventory.inventoryAdapters;

import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.IInventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryUtils.AssortedInventoryUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AssortedInventoryAdapter
implements IInventoryAdapter {
    private final ArrayList<ItemStack> itemStacks;
    private final BlockEntity blockEntity;

    public AssortedInventoryAdapter(ArrayList<ItemStack> itemStacks, BlockEntity blockEntity) {
        this.itemStacks = itemStacks;
        this.blockEntity = blockEntity;
    }

    @Override
    public ItemStack containsItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        for (ItemStack stack : this.itemStacks) {
            if (!this.compareStacks(stack, itemStack)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void removeItem(int index, int amount) {
        this.extractItem(index, amount);
    }

    @Override
    public boolean addItem(ItemStack itemStack) {
        int size = this.itemStacks.size();
        ItemStack tranferStack = itemStack.copyWithCount(1);
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.itemStacks.get(i);
            if (this.canCombineStacks(stack, tranferStack) && stack.getCount() < stack.getMaxStackSize()) {
                this.insertItem(i, tranferStack);
                return true;
            }
            if (!stack.isEmpty()) continue;
            this.insertItem(i, tranferStack);
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<ItemStack> getAllStacks() {
        return this.itemStacks;
    }

    @Override
    public int getSize() {
        return this.itemStacks.size();
    }

    private void extractItem(int index, int amount) {
        try {
            Object storageHandler = AssortedInventoryUtil.getAssortedStorageItemStackStorageHandler(this.blockEntity);
            Class<?> itemStackStorageHandlerClass = Class.forName("com.grim3212.assorted.lib.core.inventory.impl.ItemStackStorageHandler");
            Method insertItemMethod = itemStackStorageHandlerClass.getDeclaredMethod("extractItem", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            insertItemMethod.invoke(storageHandler, index, amount, false);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void insertItem(int index, ItemStack itemstack) {
        try {
            Object storageHandler = AssortedInventoryUtil.getAssortedStorageItemStackStorageHandler(this.blockEntity);
            Class<?> itemStackStorageHandlerClass = Class.forName("com.grim3212.assorted.lib.core.inventory.impl.ItemStackStorageHandler");
            Method insertItemMethod = itemStackStorageHandlerClass.getDeclaredMethod("insertItem", Integer.TYPE, ItemStack.class, Boolean.TYPE);
            insertItemMethod.invoke(storageHandler, index, itemstack, false);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

