/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.inventory.inventoryAdapters;

import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.IInventoryAdapter;
import java.util.ArrayList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class InventoryAdapter
implements IInventoryAdapter {
    private final Container inventory;

    public InventoryAdapter(Container inventory) {
        this.inventory = inventory;
    }

    @Override
    public ItemStack containsItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int size = this.inventory.getContainerSize();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (!this.compareStacks(stack, itemStack)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void removeItem(int index, int amount) {
        this.inventory.removeItem(index, amount);
    }

    @Override
    public boolean addItem(ItemStack itemStack) {
        int size = this.inventory.getContainerSize();
        ItemStack tranferStack = itemStack.copyWithCount(1);
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (this.canCombineStacks(stack, tranferStack) && stack.getCount() < stack.getMaxStackSize()) {
                stack.grow(1);
                this.inventory.setChanged();
                return true;
            }
            if (!stack.isEmpty()) continue;
            this.inventory.setItem(i, tranferStack);
            this.inventory.setChanged();
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<ItemStack> getAllStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        int size = this.inventory.getContainerSize();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.inventory.getItem(i);
            stacks.add(stack);
        }
        return stacks;
    }

    @Override
    public int getSize() {
        return this.inventory.getContainerSize();
    }
}

