/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.block.custom;

import cz.lukesmith.automaticsorter.block.entity.FilterBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class FilterBlock
extends BaseEntityBlock {
    public static final EnumProperty<Direction> FACING = EnumProperty.m_61587_((String)"facing", Direction.class);
    public static BlockPos pos = BlockPos.f_121853_;

    public FilterBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(FACING, (Comparable)Direction.UP));
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        Object object = pParams.m_287159_(LootContextParams.f_81462_);
        if (object instanceof FilterBlockEntity) {
            FilterBlockEntity filterBlockEntity = (FilterBlockEntity)((Object)object);
            Containers.m_19002_((Level)pParams.m_287258_(), (BlockPos)pos, (Container)filterBlockEntity.getContainer());
        }
        return super.m_49635_(pState, pParams);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Vec3[][] shapes = this.getShapesForFacing((Direction)pState.m_61143_(FACING));
        VoxelShape shape = Shapes.m_83040_();
        for (Vec3[] shapePart : shapes) {
            shapePart[0] = shapePart[0].m_82490_(0.0625);
            shapePart[1] = shapePart[1].m_82490_(0.0625);
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)shapePart[0].m_82507_(Direction.Axis.X), (double)shapePart[0].m_82507_(Direction.Axis.Y), (double)shapePart[0].m_82507_(Direction.Axis.Z), (double)shapePart[1].m_82507_(Direction.Axis.X), (double)shapePart[1].m_82507_(Direction.Axis.Y), (double)shapePart[1].m_82507_(Direction.Axis.Z)));
        }
        return shape;
    }

    private Vec3[][] getShapesForFacing(Direction facing) {
        Vec3[][] shapes = new Vec3[][]{{new Vec3(6.0, 0.0, 6.0), new Vec3(10.0, 9.0, 10.0)}, {new Vec3(3.0, 9.0, 3.0), new Vec3(13.0, 13.0, 13.0)}, {new Vec3(2.0, 13.0, 2.0), new Vec3(14.0, 16.0, 14.0)}};
        switch (facing) {
            case DOWN: {
                shapes[0] = new Vec3[]{new Vec3(6.0, 7.0, 6.0), new Vec3(10.0, 16.0, 10.0)};
                shapes[1] = new Vec3[]{new Vec3(3.0, 3.0, 3.0), new Vec3(13.0, 7.0, 13.0)};
                shapes[2] = new Vec3[]{new Vec3(2.0, 0.0, 2.0), new Vec3(14.0, 3.0, 14.0)};
                break;
            }
            case NORTH: {
                shapes[0] = new Vec3[]{new Vec3(6.0, 6.0, 7.0), new Vec3(10.0, 10.0, 16.0)};
                shapes[1] = new Vec3[]{new Vec3(3.0, 3.0, 3.0), new Vec3(13.0, 13.0, 7.0)};
                shapes[2] = new Vec3[]{new Vec3(2.0, 2.0, 0.0), new Vec3(14.0, 14.0, 3.0)};
                break;
            }
            case SOUTH: {
                shapes[0] = new Vec3[]{new Vec3(6.0, 6.0, 0.0), new Vec3(10.0, 10.0, 9.0)};
                shapes[1] = new Vec3[]{new Vec3(3.0, 3.0, 9.0), new Vec3(13.0, 13.0, 13.0)};
                shapes[2] = new Vec3[]{new Vec3(2.0, 2.0, 13.0), new Vec3(14.0, 14.0, 16.0)};
                break;
            }
            case WEST: {
                shapes[0] = new Vec3[]{new Vec3(7.0, 6.0, 6.0), new Vec3(16.0, 10.0, 10.0)};
                shapes[1] = new Vec3[]{new Vec3(3.0, 3.0, 3.0), new Vec3(7.0, 13.0, 13.0)};
                shapes[2] = new Vec3[]{new Vec3(0.0, 2.0, 2.0), new Vec3(3.0, 14.0, 14.0)};
                break;
            }
            case EAST: {
                shapes[0] = new Vec3[]{new Vec3(0.0, 6.0, 6.0), new Vec3(9.0, 10.0, 10.0)};
                shapes[1] = new Vec3[]{new Vec3(9.0, 3.0, 3.0), new Vec3(13.0, 13.0, 13.0)};
                shapes[2] = new Vec3[]{new Vec3(13.0, 2.0, 2.0), new Vec3(16.0, 14.0, 14.0)};
            }
        }
        return shapes;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        pos = pPos;
        return new FilterBlockEntity(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener m_214009_(ServerLevel pLevel, T pBlockEntity) {
        return super.m_214009_(pLevel, pBlockEntity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) return InteractionResult.SUCCESS;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof MenuProvider)) throw new IllegalStateException("Our Container provider is missing!");
        MenuProvider provider = (MenuProvider)blockEntity;
        if (!(player instanceof ServerPlayer)) throw new IllegalStateException("Our Container provider is missing!");
        ServerPlayer serverPlayer = (ServerPlayer)player;
        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)provider, (BlockPos)pos);
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)context.m_43719_().m_122424_());
    }
}

