/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.block.custom;

import cz.lukesmith.automaticsorter.block.custom.FilterBlock;
import cz.lukesmith.automaticsorter.block.custom.SorterControllerBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PipeBlock
extends Block {
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");

    public PipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.m_83048_((double)0.375, (double)0.375, (double)0.375, (double)0.625, (double)0.625, (double)0.625);
        int[][] directions = new int[][]{{6, 6, 0, 10, 10, 6}, {6, 6, 10, 10, 10, 16}, {10, 6, 6, 16, 10, 10}, {0, 6, 6, 6, 10, 10}, {6, 10, 6, 10, 16, 10}, {6, 0, 6, 10, 6, 10}};
        boolean[] directionsActive = new boolean[]{(Boolean)state.m_61143_((Property)NORTH), (Boolean)state.m_61143_((Property)SOUTH), (Boolean)state.m_61143_((Property)EAST), (Boolean)state.m_61143_((Property)WEST), (Boolean)state.m_61143_((Property)UP), (Boolean)state.m_61143_((Property)DOWN)};
        for (int i = 0; i < directions.length; ++i) {
            if (!directionsActive[i]) continue;
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)((double)directions[i][0] / 16.0), (double)((double)directions[i][1] / 16.0), (double)((double)directions[i][2] / 16.0), (double)((double)directions[i][3] / 16.0), (double)((double)directions[i][4] / 16.0), (double)((double)directions[i][5] / 16.0)));
        }
        return shape;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        boolean isConnected = this.isConnectedToNeighbor(pNeighborState, pDirection);
        return (BlockState)pState.m_61124_((Property)this.getPropertyForDirection(pDirection), (Comparable)Boolean.valueOf(isConnected));
    }

    private boolean isConnectedToNeighbor(BlockState neighborState, Direction direction) {
        if (direction == Direction.UP && neighborState.m_60734_() instanceof SorterControllerBlock) {
            return true;
        }
        if (neighborState.m_60734_() instanceof FilterBlock) {
            Direction filterFacing = (Direction)neighborState.m_61143_(FilterBlock.FACING);
            return direction == filterFacing;
        }
        return neighborState.m_60734_() instanceof PipeBlock;
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, world, pos, oldState, isMoving);
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos = pos.m_121945_(direction);
            BlockState neighborState = world.m_8055_(neighborPos);
            state = (BlockState)state.m_61124_((Property)this.getPropertyForDirection(direction), (Comparable)Boolean.valueOf(this.isConnectedToNeighbor(neighborState, direction)));
        }
        world.m_7731_(pos, state, 3);
    }

    private BooleanProperty getPropertyForDirection(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> NORTH;
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.UP -> UP;
            case Direction.DOWN -> DOWN;
        };
    }
}

