/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.block.entity;

import cz.lukesmith.automaticsorter.block.entity.ModBlockEntities;
import cz.lukesmith.automaticsorter.screen.FilterScreenHandler;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class FilterBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler inventory = new ItemStackHandler(24){

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }

        protected void onContentsChanged(int slot) {
            FilterBlockEntity.this.m_6596_();
            if (!FilterBlockEntity.this.f_58857_.m_5776_()) {
                FilterBlockEntity.this.f_58857_.m_7260_(FilterBlockEntity.this.m_58899_(), FilterBlockEntity.this.m_58900_(), FilterBlockEntity.this.m_58900_(), 3);
            }
        }
    };
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private int filterType = FilterTypeEnum.IN_INVENTORY.getValue();

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryCap.invalidate();
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public Container getContainer() {
        return new Container(){

            public int m_6643_() {
                return FilterBlockEntity.this.inventory.getSlots();
            }

            public boolean m_7983_() {
                for (int i = 0; i < this.m_6643_(); ++i) {
                    if (this.m_8020_(i).m_41619_()) continue;
                    return false;
                }
                return true;
            }

            @NotNull
            public ItemStack m_8020_(int index) {
                return FilterBlockEntity.this.inventory.getStackInSlot(index);
            }

            @NotNull
            public ItemStack m_7407_(int index, int count) {
                return FilterBlockEntity.this.inventory.extractItem(index, count, false);
            }

            @NotNull
            public ItemStack m_8016_(int pSlot) {
                ItemStack stack = FilterBlockEntity.this.inventory.getStackInSlot(pSlot);
                if (!stack.m_41619_()) {
                    FilterBlockEntity.this.inventory.setStackInSlot(pSlot, ItemStack.f_41583_);
                    return stack;
                }
                return ItemStack.f_41583_;
            }

            public void m_6836_(int index, @NotNull ItemStack stack) {
                FilterBlockEntity.this.inventory.setStackInSlot(index, stack);
            }

            public void m_6596_() {
            }

            public boolean m_6542_(@NotNull Player pPlayer) {
                return false;
            }

            public void m_6211_() {
                FilterBlockEntity.this.inventory.setSize(0);
            }
        };
    }

    public FilterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.FILTER_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.inventory.deserializeNBT(pTag.m_128469_("FilterInventory"));
        this.filterType = pTag.m_128451_("FilterType");
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128365_("FilterInventory", (Tag)this.inventory.serializeNBT());
        pTag.m_128405_("FilterType", this.filterType);
    }

    public static FilterBlockEntity create(BlockPos pos, BlockState state) {
        return new FilterBlockEntity(pos, state);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"automaticsorter.filter_block_entity");
    }

    public int getFilterType() {
        return this.filterType;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.m_58899_(), this.m_58900_(), 3);
        }
    }

    public void setFilterType(int filterType) {
        this.filterType = filterType;
        this.m_6596_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new FilterScreenHandler(pContainerId, pPlayerInventory, this, new ContainerData(){

            public int m_6413_(int index) {
                if (index == 0) {
                    return FilterBlockEntity.this.filterType;
                }
                return 0;
            }

            public void m_8050_(int index, int value) {
                if (index == 0) {
                    FilterBlockEntity.this.filterType = value;
                }
            }

            public int m_6499_() {
                return 1;
            }
        });
    }

    public static enum FilterTypeEnum {
        WHITELIST(0),
        IN_INVENTORY(1),
        REJECTS(2);

        private final int value;

        private FilterTypeEnum(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static FilterTypeEnum fromValue(int value) {
            for (FilterTypeEnum type : FilterTypeEnum.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown enum value: " + value);
        }

        public static int nextValue(int number) {
            return switch (FilterTypeEnum.fromValue(number)) {
                default -> throw new IncompatibleClassChangeError();
                case WHITELIST -> IN_INVENTORY.getValue();
                case IN_INVENTORY -> REJECTS.getValue();
                case REJECTS -> WHITELIST.getValue();
            };
        }

        public static String getName(FilterTypeEnum type) {
            return switch (type) {
                default -> throw new IncompatibleClassChangeError();
                case WHITELIST -> "Whitelist";
                case IN_INVENTORY -> "In Inventory";
                case REJECTS -> "Rejects";
            };
        }

        public static String getName(int value) {
            return FilterTypeEnum.getName(FilterTypeEnum.fromValue(value));
        }
    }
}

