/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.inventory.inventoryAdapters;

import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.IInventoryAdapter;
import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;

public class MultiInventoryAdapter
implements IInventoryAdapter {
    private ArrayList<IInventoryAdapter> inventoryAdapters = new ArrayList();

    public MultiInventoryAdapter(IInventoryAdapter inventoryAdapters) {
        this.inventoryAdapters.add(inventoryAdapters);
    }

    @Override
    public ItemStack containsItem(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        for (IInventoryAdapter inventoryAdapter : this.inventoryAdapters) {
            ItemStack stack = inventoryAdapter.containsItem(itemStack);
            if (stack.m_41619_()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void removeItem(int index, int amount) {
        int i = 0;
        for (IInventoryAdapter inventoryAdapter : this.inventoryAdapters) {
            if (index < i + inventoryAdapter.getSize()) {
                inventoryAdapter.removeItem(index - i, amount);
                return;
            }
            i += inventoryAdapter.getSize();
        }
    }

    @Override
    public boolean addItem(ItemStack itemStack) {
        for (IInventoryAdapter inventoryAdapter : this.inventoryAdapters) {
            if (!inventoryAdapter.addItem(itemStack)) continue;
            return true;
        }
        return false;
    }

    public void addInventoryAdapter(IInventoryAdapter inventoryAdapter) {
        this.inventoryAdapters.add(inventoryAdapter);
    }

    public void addInventoryAdapterAsFirst(IInventoryAdapter inventoryAdapter) {
        this.inventoryAdapters.add(0, inventoryAdapter);
    }

    public void setInventoryAdapters(ArrayList<IInventoryAdapter> inventoryAdapters) {
        this.inventoryAdapters = inventoryAdapters;
    }

    @Override
    public ArrayList<ItemStack> getAllStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (IInventoryAdapter inventoryAdapter : this.inventoryAdapters) {
            stacks.addAll(inventoryAdapter.getAllStacks());
        }
        return stacks;
    }

    @Override
    public int getSize() {
        int size = 0;
        for (IInventoryAdapter inventoryAdapter : this.inventoryAdapters) {
            size += inventoryAdapter.getSize();
        }
        return size;
    }
}

