/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.inventory.inventoryUtils;

import cz.lukesmith.automaticsorter.block.entity.FilterBlockEntity;
import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.IInventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.InventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.NoInventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryUtils.AssortedInventoryUtil;
import cz.lukesmith.automaticsorter.inventory.inventoryUtils.ExpandedInventoryUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class MainInventoryUtil {
    @NotNull
    public static IInventoryAdapter getInventoryAdapter(Level world, BlockPos pos) {
        ExpandedInventoryUtil expandedIU = new ExpandedInventoryUtil();
        AssortedInventoryUtil assortedIU = new AssortedInventoryUtil();
        Block block = world.m_8055_(pos).m_60734_();
        BlockEntity blockEntity = world.m_7702_(pos);
        if (block instanceof ChestBlock) {
            ChestBlock chestBlock = (ChestBlock)block;
            return new InventoryAdapter(ChestBlock.m_51511_((ChestBlock)chestBlock, (BlockState)world.m_8055_(pos), (Level)world, (BlockPos)pos, (boolean)true));
        }
        if (blockEntity instanceof Container) {
            Container inventory = (Container)blockEntity;
            if (expandedIU.isRelatedStorage(block, blockEntity)) {
                return expandedIU.getInventoryAdapter(world, pos, block, blockEntity);
            }
            return new InventoryAdapter(inventory);
        }
        if (blockEntity instanceof FilterBlockEntity) {
            FilterBlockEntity filterBlockEntity = (FilterBlockEntity)blockEntity;
            return new InventoryAdapter(filterBlockEntity.getContainer());
        }
        if (assortedIU.isRelatedStorage(block, blockEntity)) {
            return assortedIU.getInventoryAdapter(world, pos, block, blockEntity);
        }
        return new NoInventoryAdapter();
    }
}

