/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.network;

import cz.lukesmith.automaticsorter.block.entity.FilterBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class FilterTypePacket {
    private final BlockPos pos;
    private final int filterType;

    public FilterTypePacket(BlockPos pos, int filterType) {
        this.pos = pos;
        this.filterType = filterType;
    }

    public static void encode(FilterTypePacket msg, FriendlyByteBuf buf) {
        buf.m_130064_(msg.pos);
        buf.writeInt(msg.filterType);
    }

    public static FilterTypePacket decode(FriendlyByteBuf buf) {
        return new FilterTypePacket(buf.m_130135_(), buf.readInt());
    }

    public static void handle(FilterTypePacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Level level = player.m_9236_();
            BlockEntity patt1317$temp = level.m_7702_(msg.pos);
            if (patt1317$temp instanceof FilterBlockEntity) {
                FilterBlockEntity fe = (FilterBlockEntity)patt1317$temp;
                fe.setFilterType(msg.filterType);
                fe.m_6596_();
            }
        });
        context.setPacketHandled(true);
    }
}

