/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.screen;

import cz.lukesmith.automaticsorter.block.ModBlocks;
import cz.lukesmith.automaticsorter.block.entity.FilterBlockEntity;
import cz.lukesmith.automaticsorter.network.FilterTypePacket;
import cz.lukesmith.automaticsorter.network.NetworkHandler;
import cz.lukesmith.automaticsorter.screen.FilterScreenHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class FilterScreen
extends AbstractContainerScreen<FilterScreenHandler> {
    private static final ResourceLocation TEXTURE = ResourceLocation.m_214293_((String)"automaticsorter", (String)"textures/gui/filter.png");
    private Button receiveItemsButton;
    private static final ItemStack CHEST_BLOCK = new ItemStack((ItemLike)Blocks.f_50087_);
    private static final ItemStack FILTER_BLOCK = new ItemStack((ItemLike)ModBlocks.FILTER_BLOCK.get());
    private static final ItemStack REJECTS = new ItemStack((ItemLike)Blocks.f_50375_);

    public FilterScreen(FilterScreenHandler handler, Inventory inv, Component title) {
        super((AbstractContainerMenu)handler, inv, title);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280163_(TEXTURE, x, y, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
    }

    private Component getButtonText() {
        return Component.m_237113_((String)FilterBlockEntity.FilterTypeEnum.getName(((FilterScreenHandler)this.f_97732_).getFilterType()));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_97731_ = 1000;
        this.f_97729_ = 1000;
        this.receiveItemsButton = new Button.Builder((Component)Component.m_237113_((String)""), button -> {
            int value = ((FilterScreenHandler)this.f_97732_).toggleFilterType();
            this.sendFilterTypeUpdate(value);
        }).m_252794_(this.f_97735_ + 6, this.f_97736_ + 14).m_253046_(18, 18).m_253136_();
        this.m_142416_((GuiEventListener)this.receiveItemsButton);
    }

    private void sendFilterTypeUpdate(int value) {
        BlockPos pos = ((FilterScreenHandler)this.f_97732_).getBlockPos();
        FilterTypePacket packet = new FilterTypePacket(pos, value);
        NetworkHandler.CHANNEL.sendToServer((Object)packet);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.m_7286_(context, delta, mouseX, mouseY);
        super.m_88315_(context, mouseX, mouseY, delta);
        this.m_280072_(context, mouseX, mouseY);
        if (this.receiveItemsButton.m_5953_((double)mouseX, (double)mouseY)) {
            context.m_280557_(this.f_96547_, this.getButtonText(), mouseX, mouseY);
        }
        if (!this.receiveItemsButton.m_5953_((double)mouseX, (double)mouseY)) {
            this.receiveItemsButton.m_93692_(false);
        }
        int filterType = ((FilterScreenHandler)this.f_97732_).getFilterType();
        ItemStack renderButtonBlock = this.getDisplayedItemStack();
        context.m_280480_(renderButtonBlock, this.f_97735_ + 7, this.f_97736_ + 15);
        switch (FilterBlockEntity.FilterTypeEnum.fromValue(filterType)) {
            case REJECTS: 
            case IN_INVENTORY: {
                int x = this.f_97735_ + 25;
                int y = this.f_97736_ + 14;
                int width = 144;
                int height = 54;
                int color = Integer.MIN_VALUE;
                context.m_280509_(x, y, x + width, y + height, color);
                break;
            }
        }
    }

    private ItemStack getDisplayedItemStack() {
        int filterType = ((FilterScreenHandler)this.f_97732_).getFilterType();
        if (filterType == FilterBlockEntity.FilterTypeEnum.WHITELIST.getValue()) {
            return FILTER_BLOCK;
        }
        if (filterType == FilterBlockEntity.FilterTypeEnum.IN_INVENTORY.getValue()) {
            return CHEST_BLOCK;
        }
        return REJECTS;
    }
}

