/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.screen;

import cz.lukesmith.automaticsorter.block.ModBlocks;
import cz.lukesmith.automaticsorter.block.entity.FilterBlockEntity;
import cz.lukesmith.automaticsorter.screen.ModScreenHandlers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class FilterScreenHandler
extends AbstractContainerMenu {
    private final FilterBlockEntity blockEntity;
    private final Level level;
    private final ContainerData propertyDelegate;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int FILTER_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int FILTER_INVENTORY_SLOT_COUNT = 24;

    public FilterScreenHandler(int containerId, Inventory playerInventory, FriendlyByteBuf extraData) {
        this(containerId, playerInventory, playerInventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()), (ContainerData)new SimpleContainerData(1));
    }

    public FilterScreenHandler(int containerId, Inventory playerInventory, BlockEntity be, ContainerData data) {
        super((MenuType)ModScreenHandlers.FILTER_SCREEN_HANDLER.get(), containerId);
        if (!(be instanceof FilterBlockEntity)) {
            throw new IllegalStateException("Invalid block entity at container open");
        }
        FilterBlockEntity filterBe = (FilterBlockEntity)be;
        this.blockEntity = filterBe;
        this.level = playerInventory.f_35978_.m_9236_();
        this.propertyDelegate = data;
        ItemStackHandler inventory = this.blockEntity.getInventory();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 8; ++j) {
                int slot = j + i * 8;
                int x = 26 + j * 18;
                int y = 15 + i * 18;
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inventory, slot, x, y));
            }
        }
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.m_38884_(data);
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public boolean m_6875_(Player player) {
        return FilterScreenHandler.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)ModBlocks.FILTER_BLOCK.get()));
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copy = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 60, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 60) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41619_()) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(player, sourceStack);
        return copy;
    }

    public int getFilterType() {
        return this.propertyDelegate.m_6413_(0);
    }

    public int toggleFilterType() {
        int value = FilterBlockEntity.FilterTypeEnum.nextValue(this.getFilterType());
        this.propertyDelegate.m_8050_(0, value);
        this.blockEntity.m_6596_();
        return value;
    }

    public BlockPos getBlockPos() {
        return this.blockEntity.m_58899_();
    }
}

