/*
 * Decompiled with CFR 0.152.
 */
package cz.lukesmith.automaticsorter.inventory.inventoryAdapters;

import cz.lukesmith.automaticsorter.inventory.inventoryAdapters.IInventoryAdapter;
import cz.lukesmith.automaticsorter.inventory.inventoryUtils.AssortedInventoryUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.class_1799;
import net.minecraft.class_2586;

public class AssortedInventoryAdapter
implements IInventoryAdapter {
    private final ArrayList<class_1799> itemStacks;
    private final class_2586 blockEntity;

    public AssortedInventoryAdapter(ArrayList<class_1799> itemStacks, class_2586 blockEntity) {
        this.itemStacks = itemStacks;
        this.blockEntity = blockEntity;
    }

    @Override
    public class_1799 containsItem(class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        for (class_1799 stack : this.itemStacks) {
            if (!this.compareStacks(stack, itemStack)) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    @Override
    public void removeItem(int index, int amount) {
        this.extractItem(index, amount);
    }

    @Override
    public int addItem(class_1799 itemStack, int maxAmount) {
        int size = this.itemStacks.size();
        int toTransfer = Math.min(maxAmount, itemStack.method_7947());
        int transferred = 0;
        for (int i = 0; i < size && transferred < toTransfer; ++i) {
            class_1799 stack = this.itemStacks.get(i);
            if (this.canCombineStacks(stack, itemStack) && stack.method_7947() < stack.method_7914()) {
                int canAdd = Math.min(toTransfer - transferred, stack.method_7914() - stack.method_7947());
                class_1799 addStack = itemStack.method_46651(canAdd);
                this.insertItem(i, addStack);
                transferred += canAdd;
                continue;
            }
            if (!stack.method_7960()) continue;
            int put = toTransfer - transferred;
            class_1799 newStack = itemStack.method_46651(put);
            this.insertItem(i, newStack);
            transferred += put;
        }
        return transferred;
    }

    @Override
    public ArrayList<class_1799> getAllStacks() {
        return this.itemStacks;
    }

    @Override
    public int getSize() {
        return this.itemStacks.size();
    }

    private void extractItem(int index, int amount) {
        try {
            Object storageHandler = AssortedInventoryUtil.getAssortedStorageItemStackStorageHandler(this.blockEntity);
            Class<?> itemStackStorageHandlerClass = Class.forName("com.grim3212.assorted.lib.core.inventory.impl.ItemStackStorageHandler");
            Method insertItemMethod = itemStackStorageHandlerClass.getDeclaredMethod("extractItem", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            insertItemMethod.invoke(storageHandler, index, amount, false);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void insertItem(int index, class_1799 itemstack) {
        try {
            Object storageHandler = AssortedInventoryUtil.getAssortedStorageItemStackStorageHandler(this.blockEntity);
            Class<?> itemStackStorageHandlerClass = Class.forName("com.grim3212.assorted.lib.core.inventory.impl.ItemStackStorageHandler");
            Method insertItemMethod = itemStackStorageHandlerClass.getDeclaredMethod("insertItem", Integer.TYPE, class_1799.class, Boolean.TYPE);
            insertItemMethod.invoke(storageHandler, index, itemstack, false);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

