/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.client;

import java.util.List;
import java.util.Optional;
import net.levelscraft7.rustlingspots.registry.RustlingParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RustlingParticleResourceValidator
implements ResourceManagerReloadListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RustlingParticleResourceValidator.class);
    private static final List<ResourceLocation> EXPECTED_TEXTURES = RustlingParticleTypes.particleTextures();

    public static void register(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new RustlingParticleResourceValidator());
    }

    public void onResourceManagerReload(ResourceManager resourceManager) {
        LOGGER.info("Rustling Spots: validating particle textures ({} expected entries)", (Object)EXPECTED_TEXTURES.size());
        for (ResourceLocation texture : EXPECTED_TEXTURES) {
            ResourceLocation textureFile = texture.withPath("textures/particle/" + texture.getPath() + ".png");
            Optional resource = resourceManager.getResource(textureFile);
            if (resource.isPresent()) {
                LOGGER.info("Rustling Spots: texture found -> {} (pack: {})", (Object)texture, (Object)((Resource)resource.get()).sourcePackId());
                continue;
            }
            String filename = texture.getPath().substring(texture.getPath().lastIndexOf(47) + 1);
            LOGGER.warn("Rustling Spots: texture missing -> {} (resolved path: {}). Expected under assets/{}/textures/particle/{}.png including optional top-level /resources override.", new Object[]{texture, textureFile, "rustlingspots", filename});
        }
    }
}

