/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.client.particle;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RustlingBurstParticle
extends TextureSheetParticle {
    private static final Logger LOGGER = LoggerFactory.getLogger(RustlingBurstParticle.class);
    private static final ConcurrentMap<String, Boolean> LOGGED_SPRITE_FAILURES = new ConcurrentHashMap<String, Boolean>();
    private final SpriteSet sprites;
    private final Style style;
    private final boolean hasSprites;
    private boolean spriteReady;
    private final String debugId;

    protected RustlingBurstParticle(ClientLevel level, double x, double y, double z, double velocityX, double velocityY, double velocityZ, SpriteSet sprites, Style style, String debugId) {
        super(level, x, y, z, velocityX, velocityY, velocityZ);
        boolean needsMotion;
        this.sprites = sprites;
        this.style = style;
        this.hasSprites = sprites != null;
        this.debugId = debugId;
        this.friction = style.friction();
        this.gravity = style.gravity();
        this.hasPhysics = true;
        boolean bl = needsMotion = Math.abs(velocityX) < 1.0E-4 && Math.abs(velocityY) < 1.0E-4 && Math.abs(velocityZ) < 1.0E-4;
        if (needsMotion) {
            this.xd = (this.random.nextDouble() - 0.5) * 0.08;
            this.zd = (this.random.nextDouble() - 0.5) * 0.08;
            this.yd = 0.06 + this.random.nextDouble() * 0.04;
        } else {
            this.xd *= 0.65;
            this.yd *= 0.8;
            this.zd *= 0.65;
        }
        float jitter = (float)((double)style.scaleJitter() * (level.random.nextDouble() - 0.5));
        this.quadSize *= style.scaleMultiplier() + jitter;
        this.lifetime = style.minLifetime() + level.random.nextInt(style.maxLifetime() - style.minLifetime() + 1);
        this.alpha = 0.0f;
        this.roll = this.oRoll = level.random.nextFloat() * ((float)Math.PI * 2);
        this.spriteReady = this.ensureSpriteBound();
    }

    public static ParticleProvider<SimpleParticleType> provider(SpriteSet sprites, Style style, String debugId) {
        return (type, level, x, y, z, dx, dy, dz) -> new RustlingBurstParticle(level, x, y, z, dx, dy, dz, sprites, style, debugId);
    }

    public void tick() {
        float progress;
        super.tick();
        if (!this.spriteReady) {
            this.spriteReady = this.ensureSpriteBound();
        }
        this.alpha = (progress = (float)this.age / (float)this.lifetime) < 0.25f ? Mth.clamp((float)(progress / 0.25f), (float)0.0f, (float)1.0f) : (progress > 0.75f ? Mth.clamp((float)(1.0f - (progress - 0.75f) / 0.25f), (float)0.0f, (float)1.0f) : 1.0f);
        this.yd += (double)this.style.riseAcceleration();
    }

    private boolean ensureSpriteBound() {
        if (!this.hasSprites) {
            this.logSpriteIssue("sprite set handle is null");
            this.remove();
            return false;
        }
        try {
            this.setSprite(this.sprites.get(this.random));
        }
        catch (Exception e) {
            this.logSpriteIssue("setSprite threw: " + e.getMessage());
        }
        if (this.sprite == null) {
            this.logSpriteIssue("sprite set returned null sprite");
            this.remove();
            return false;
        }
        ResourceLocation spriteName = this.sprite.contents().name();
        if (MissingTextureAtlasSprite.getLocation().equals((Object)spriteName)) {
            this.logSpriteIssue("sprite resolved to missing texture atlas sprite");
            this.remove();
            return false;
        }
        if (!this.spriteReady) {
            // empty if block
        }
        return true;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    private void logSpriteIssue(String reason) {
        if (this.debugId == null) {
            return;
        }
        LOGGED_SPRITE_FAILURES.computeIfAbsent(this.debugId, key -> {
            LOGGER.warn("Rustling Spots: {} has no usable sprite set ({}). The particle will be discarded.", key, (Object)reason);
            return true;
        });
    }

    public record Style(float scaleMultiplier, float scaleJitter, int minLifetime, int maxLifetime, float friction, float gravity, float riseAcceleration) {
    }
}

