/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.config;

import net.levelscraft7.rustlingspots.config.ConfigPathHelper;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class RustlingSpotsPokemonConfig {
    public static final PokemonSpawn POKEMON_SPAWN;
    public static final ModConfigSpec SPEC;

    private RustlingSpotsPokemonConfig() {
    }

    public static void register(ModLoadingContext context) {
        context.getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SPEC, ConfigPathHelper.ensurePath("rustlingspots/rustlingspots-pokemon.toml"));
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        POKEMON_SPAWN = new PokemonSpawn(builder);
        SPEC = builder.build();
    }

    public static final class PokemonSpawn {
        private final ModConfigSpec.BooleanValue enable;
        private final ModConfigSpec.DoubleValue encounterChance;
        private final ModConfigSpec.IntValue minLevel;
        private final ModConfigSpec.IntValue maxLevel;
        private final ModConfigSpec.BooleanValue typedSpawnRules;
        private final ModConfigSpec.DoubleValue defaultShinyChance;

        private PokemonSpawn(ModConfigSpec.Builder builder) {
            builder.comment("Controls for Pok\u00e9mon encounters").push("pokemon_spawn");
            this.enable = builder.comment("Enable or disable Pok\u00e9mon encounters inside Rustling Spots").define("enable", true);
            this.encounterChance = builder.comment("Probability that a rustling spot will try to spawn a Pok\u00e9mon instead of items").defineInRange("encounter_chance", 0.35, 0.0, 1.0);
            this.defaultShinyChance = builder.comment("Base probability that a spawned Pok\u00e9mon will be shiny when not overridden by pool data").defineInRange("default_shiny_chance", 0.05, 0.0, 1.0);
            this.minLevel = builder.comment("Minimum level for spawned Pok\u00e9mon").defineInRange("min_level", 5, 1, Integer.MAX_VALUE);
            this.maxLevel = builder.comment("Maximum level for spawned Pok\u00e9mon").defineInRange("max_level", 75, 1, Integer.MAX_VALUE);
            this.typedSpawnRules = builder.comment("If true, Pok\u00e9mon selection must follow the (family + biome-group) type rules").define("typed_spawn_rules", true);
            builder.pop();
        }

        public boolean enable() {
            return (Boolean)this.enable.get();
        }

        public double encounterChance() {
            double chance = (Double)this.encounterChance.get();
            return Math.max(0.0, Math.min(1.0, chance));
        }

        public double defaultShinyChance() {
            double chance = (Double)this.defaultShinyChance.get();
            return Math.max(0.0, Math.min(1.0, chance));
        }

        public int minLevel() {
            int min = Math.max(1, (Integer)this.minLevel.get());
            int max = Math.max(1, (Integer)this.maxLevel.get());
            return Math.min(min, max);
        }

        public int maxLevel() {
            int min = Math.max(1, (Integer)this.minLevel.get());
            int max = Math.max(1, (Integer)this.maxLevel.get());
            return Math.max(min, max);
        }

        public boolean typedSpawnRules() {
            return (Boolean)this.typedSpawnRules.get();
        }
    }
}

