/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.config;

import java.util.List;
import net.levelscraft7.rustlingspots.config.ConfigPathHelper;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class RustlingSpotsServerConfig {
    public static final General GENERAL;
    public static final ModConfigSpec SPEC;

    private RustlingSpotsServerConfig() {
    }

    public static void register(ModLoadingContext context) {
        context.getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SPEC, ConfigPathHelper.ensurePath("rustlingspots/rustlingspots-server.toml"));
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        GENERAL = new General(builder);
        SPEC = builder.build();
    }

    public static final class General {
        private final ModConfigSpec.BooleanValue enabled;
        private final ModConfigSpec.DoubleValue spawnDensity;
        private final ModConfigSpec.IntValue minDistanceBetweenSpots;
        private final ModConfigSpec.IntValue maxDistanceBetweenSpots;
        private final ModConfigSpec.IntValue spawnMinDistanceFromPlayer;
        private final ModConfigSpec.IntValue spawnMaxDistanceFromPlayer;
        private final ModConfigSpec.IntValue spotLifetimeTicks;
        private final ModConfigSpec.IntValue despawnIfNoPlayerWithin;
        private final ModConfigSpec.DoubleValue interactionRadius;
        private final ModConfigSpec.DoubleValue interactionVerticalAllowance;
        private final ModConfigSpec.IntValue maxSpotsPerDimension;
        private final ModConfigSpec.ConfigValue<List<? extends String>> allowedDimensions;

        private General(ModConfigSpec.Builder builder) {
            builder.comment("Master controls for rustling spots").push("general");
            this.enabled = builder.comment("Master switch to enable or disable the whole Rustling Spots system").define("enabled", true);
            this.spawnDensity = builder.comment("Chance for an eligible chunk to contain a rustling spot; 1.0 means every allowed chunk will have one").defineInRange("spawn_density", 0.4, 0.0, 1.0);
            this.minDistanceBetweenSpots = builder.comment("Minimum allowed distance between two active spots (in blocks)").defineInRange("min_distance_between_spots", 48, 0, Integer.MAX_VALUE);
            this.maxDistanceBetweenSpots = builder.comment("Soft spacing value for future balancing (not a hard limit)").defineInRange("max_distance_between_spots", 180, 0, Integer.MAX_VALUE);
            this.spawnMinDistanceFromPlayer = builder.comment("Minimum distance from a player where new spots may attempt to spawn").defineInRange("spawn_min_distance_from_player", 60, 0, Integer.MAX_VALUE);
            this.spawnMaxDistanceFromPlayer = builder.comment("Maximum distance from a player where new spots may attempt to spawn").defineInRange("spawn_max_distance_from_player", 150, 1, Integer.MAX_VALUE);
            this.spotLifetimeTicks = builder.comment("Maximum lifetime of a Rustling Spot (in ticks)").defineInRange("spot_lifetime_ticks", 6000, 1, Integer.MAX_VALUE);
            this.despawnIfNoPlayerWithin = builder.comment("If no player stays within this distance, the spot despawns").defineInRange("despawn_if_no_player_within", 150, 0, Integer.MAX_VALUE);
            this.interactionRadius = builder.comment("Radius in which a player can trigger the spot").defineInRange("interaction_radius", 1.5, 0.0, 16.0);
            this.interactionVerticalAllowance = builder.comment("Additional upward reach allowed for interaction (e.g. players on tall mounts)").defineInRange("interaction_vertical_allowance", 2.0, 0.0, 16.0);
            this.maxSpotsPerDimension = builder.comment("Maximum number of active spots allowed in the entire dimension").defineInRange("max_spots_per_dimension", 25, 1, Integer.MAX_VALUE);
            this.allowedDimensions = builder.comment("List of dimension IDs where Rustling Spots can appear").defineList("allowed_dimensions", List.of("minecraft:overworld", "minecraft:the_nether", "minecraft:the_end"), value -> {
                String raw;
                return value instanceof String && ResourceLocation.tryParse((String)(raw = (String)value)) != null;
            });
            builder.pop();
        }

        public boolean enabled() {
            return (Boolean)this.enabled.get();
        }

        public double spawnDensity() {
            double density = (Double)this.spawnDensity.get();
            return Math.max(0.0, Math.min(1.0, density));
        }

        public int minDistanceBetweenSpots() {
            return Math.max(0, (Integer)this.minDistanceBetweenSpots.get());
        }

        public int maxDistanceBetweenSpots() {
            return Math.max(0, (Integer)this.maxDistanceBetweenSpots.get());
        }

        public int spawnMinDistanceFromPlayer() {
            return Math.max(0, (Integer)this.spawnMinDistanceFromPlayer.get());
        }

        public int spawnMaxDistanceFromPlayer() {
            int min = this.spawnMinDistanceFromPlayer();
            return Math.max(min, (Integer)this.spawnMaxDistanceFromPlayer.get());
        }

        public int spotLifetimeTicks() {
            return Math.max(1, (Integer)this.spotLifetimeTicks.get());
        }

        public int despawnIfNoPlayerWithin() {
            return Math.max(0, (Integer)this.despawnIfNoPlayerWithin.get());
        }

        public double interactionRadius() {
            return Math.max(0.0, (Double)this.interactionRadius.get());
        }

        public double interactionVerticalAllowance() {
            return Math.max(0.0, (Double)this.interactionVerticalAllowance.get());
        }

        public int maxSpotsPerDimension() {
            return Math.max(1, (Integer)this.maxSpotsPerDimension.get());
        }

        public List<? extends String> allowedDimensions() {
            return (List)this.allowedDimensions.get();
        }
    }
}

