/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.config;

import net.levelscraft7.rustlingspots.config.ConfigPathHelper;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class RustlingSpotsSoundConfig {
    public static final SoundVolumes SOUNDS;
    public static final ModConfigSpec SPEC;

    private RustlingSpotsSoundConfig() {
    }

    public static void register(ModLoadingContext context) {
        context.getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, ConfigPathHelper.ensurePath("rustlingspots/rustlingspots-sounds.toml"));
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        SOUNDS = new SoundVolumes(builder);
        SPEC = builder.build();
    }

    public static final class SoundVolumes {
        private final ModConfigSpec.DoubleValue ambientVolume;
        private final ModConfigSpec.DoubleValue pokemonSpawnVolume;
        private final ModConfigSpec.DoubleValue itemRewardVolume;

        private SoundVolumes(ModConfigSpec.Builder builder) {
            builder.comment("Volume controls for Rustling Spots custom sounds").push("custom_sounds");
            this.ambientVolume = builder.comment("Volume multiplier for the ambient rustling spot sounds").defineInRange("ambient_volume", 0.4, 0.0, 4.0);
            this.pokemonSpawnVolume = builder.comment("Volume multiplier for the sound when a Pok\u00e9mon appears from a spot").defineInRange("pokemon_spawn_volume", 0.8, 0.0, 4.0);
            this.itemRewardVolume = builder.comment("Volume multiplier for the sound when receiving items from a spot").defineInRange("item_reward_volume", 0.8, 0.0, 4.0);
            builder.pop();
        }

        public float ambientVolume() {
            return this.clamp((Double)this.ambientVolume.get());
        }

        public float pokemonSpawnVolume() {
            return this.clamp((Double)this.pokemonSpawnVolume.get());
        }

        public float itemRewardVolume() {
            return this.clamp((Double)this.itemRewardVolume.get());
        }

        private float clamp(double value) {
            double clamped = Math.max(0.0, Math.min(4.0, value));
            return (float)clamped;
        }
    }
}

