/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;

public final class RustlingMessages {
    private static final List<String> POKEMON_MESSAGES = List.of("You sense something watching you... A wild {pokemon} appears!", "The rustling nearby suddenly bursts open. {pokemon} jumps out!", "Your curiosity paid off. A wild {pokemon} emerges from the rustling grass!");
    private static final List<String> LOOT_MESSAGES = List.of("You sift through the rustling spot and find {item_count}x {item}.", "Looks like someone dropped this here. You pick up {item_count}x {item} from the spot.", "The rustling fades, but you manage to grab a small stash of loot. ({item_count}x {item})");

    private RustlingMessages() {
    }

    public static Component randomPokemonMessage(String pokemon, RandomSource random) {
        String template = RustlingMessages.pickRandom(POKEMON_MESSAGES, random);
        return Component.literal((String)template.replace("{pokemon}", pokemon));
    }

    public static Component randomLootMessage(ItemStack stack, RandomSource random) {
        String template = RustlingMessages.pickRandom(LOOT_MESSAGES, random);
        String itemName = stack.getHoverName().getString();
        String replaced = template.replace("{item_count}", String.valueOf(stack.getCount())).replace("{item}", itemName);
        return Component.literal((String)replaced);
    }

    private static String pickRandom(List<String> templates, RandomSource random) {
        if (templates.isEmpty()) {
            return "";
        }
        return templates.get(random.nextInt(templates.size()));
    }
}

