/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.levelscraft7.rustlingspots.network.packet.RustlingSpotSpawnPacket;
import net.levelscraft7.rustlingspots.registry.RustlingSoundEvents;
import net.levelscraft7.rustlingspots.spot.RustlingSpot;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamily;
import net.levelscraft7.rustlingspots.spot.RustlingSpotService;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class RustlingSpotCommands {
    private static final DynamicCommandExceptionType UNKNOWN_FAMILY = new DynamicCommandExceptionType(input -> Component.literal((String)("Unknown rustling spot family: " + String.valueOf(input))));
    private static final long SPAWN_INTERACTION_DELAY_TICKS = 100L;

    @SubscribeEvent
    public void register(RegisterCommandsEvent event) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.literal((String)"rustlingspots").requires(source -> source.hasPermission(2));
        root.then(Commands.literal((String)"spawn").then(Commands.argument((String)"family", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(this.familyNames(), (SuggestionsBuilder)builder)).executes(ctx -> this.spawnSpot((CommandSourceStack)ctx.getSource(), this.parseFamily(StringArgumentType.getString((CommandContext)ctx, (String)"family"))))));
        event.getDispatcher().register(root);
    }

    private RustlingSpotFamily parseFamily(String input) throws CommandSyntaxException {
        try {
            return RustlingSpotFamily.valueOf(input.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            throw UNKNOWN_FAMILY.create((Object)input);
        }
    }

    private int spawnSpot(CommandSourceStack source, RustlingSpotFamily family) throws CommandSyntaxException {
        ServerPlayer player = source.getPlayerOrException();
        ServerLevel level = player.serverLevel();
        Vec3 base = player.position();
        Vec3 shifted = base.add(1.0, 0.0, 0.0);
        BlockPos pos = new BlockPos((int)Math.floor(shifted.x()), (int)Math.floor(shifted.y()), (int)Math.floor(shifted.z()));
        UUID id = UUID.randomUUID();
        int variant = RustlingSoundEvents.indexForFamily(family);
        RustlingSpot spot = new RustlingSpot(id, (ResourceKey<Level>)level.dimension(), pos, family, level.getGameTime(), variant);
        RustlingSpotService.MANAGER.add(spot);
        PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new RustlingSpotSpawnPacket(spot), (CustomPacketPayload[])new CustomPacketPayload[0]);
        RustlingSpotService.INTERACTION_BLOCKER.blockForTicks(player.getUUID(), level.getGameTime(), 100L);
        source.sendSuccess(() -> Component.literal((String)("Spawned rustling spot for family '" + family.name().toLowerCase(Locale.ROOT) + "' at " + pos.getX() + ", " + pos.getY() + ", " + pos.getZ())), true);
        return 1;
    }

    private List<String> familyNames() {
        return Arrays.stream(RustlingSpotFamily.values()).map(family -> family.name().toLowerCase(Locale.ROOT)).toList();
    }
}

