/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import java.util.Optional;
import net.levelscraft7.rustlingspots.config.RustlingSpotsPokemonConfig;
import net.levelscraft7.rustlingspots.config.RustlingSpotsServerConfig;
import net.levelscraft7.rustlingspots.config.RustlingSpotsSoundConfig;
import net.levelscraft7.rustlingspots.registry.RustlingSoundEvents;
import net.levelscraft7.rustlingspots.spot.LootPoolService;
import net.levelscraft7.rustlingspots.spot.PokemonSpawnResolver;
import net.levelscraft7.rustlingspots.spot.RustlingMessages;
import net.levelscraft7.rustlingspots.spot.RustlingSpot;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class SpotRewardResolver {
    private SpotRewardResolver() {
    }

    public static void resolve(ServerLevel level, ServerPlayer player, RustlingSpot spot) {
        Optional<String> spawned;
        boolean attemptPokemon;
        if (!RustlingSpotsServerConfig.GENERAL.enabled()) {
            return;
        }
        level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)spot.getPosition().getX() + 0.5, (double)spot.getPosition().getY() + 1.0, (double)spot.getPosition().getZ() + 0.5, 14, 0.3, 0.3, 0.3, 0.01);
        RandomSource random = level.random;
        boolean bl = attemptPokemon = RustlingSpotsPokemonConfig.POKEMON_SPAWN.enable() && random.nextDouble() < RustlingSpotsPokemonConfig.POKEMON_SPAWN.encounterChance();
        if (attemptPokemon && (spawned = PokemonSpawnResolver.spawn(level, player, spot, random)).isPresent()) {
            float volume = RustlingSpotsSoundConfig.SOUNDS.pokemonSpawnVolume();
            if (volume > 0.0f) {
                level.playSound(null, spot.getPosition(), (SoundEvent)RustlingSoundEvents.POKEMON_SPAWN.get(), SoundSource.AMBIENT, volume, 1.0f);
            }
            player.sendSystemMessage(RustlingMessages.randomPokemonMessage(spawned.get(), random));
            return;
        }
        ItemStack stack = SpotRewardResolver.giveLoot(level, spot, random);
        if (!stack.isEmpty()) {
            float volume = RustlingSpotsSoundConfig.SOUNDS.itemRewardVolume();
            if (volume > 0.0f) {
                level.playSound(null, spot.getPosition(), (SoundEvent)RustlingSoundEvents.ITEM_REWARD.get(), SoundSource.AMBIENT, volume, 1.0f);
            }
            player.sendSystemMessage(RustlingMessages.randomLootMessage(stack, random));
        }
    }

    private static ItemStack giveLoot(ServerLevel level, RustlingSpot spot, RandomSource random) {
        ItemStack stack = LootPoolService.pickLoot(spot.getFamily(), random);
        if (!stack.isEmpty()) {
            ItemStack copy = stack.copy();
            double x = (double)spot.getPosition().getX() + 0.5;
            double y = (double)spot.getPosition().getY() + 1.0;
            double z = (double)spot.getPosition().getZ() + 0.5;
            ItemEntity entity = new ItemEntity((Level)level, x, y, z, copy);
            entity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)entity);
            return copy;
        }
        return ItemStack.EMPTY;
    }
}

