/*
 * Decompiled with CFR 0.152.
 */
package net.levelscraft7.rustlingspots.spot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.levelscraft7.rustlingspots.config.RustlingSpotsFamilySpawnConfig;
import net.levelscraft7.rustlingspots.config.RustlingSpotsServerConfig;
import net.levelscraft7.rustlingspots.network.packet.RustlingSpotSpawnPacket;
import net.levelscraft7.rustlingspots.registry.RustlingSoundEvents;
import net.levelscraft7.rustlingspots.spot.RustlingSpot;
import net.levelscraft7.rustlingspots.spot.RustlingSpotFamily;
import net.levelscraft7.rustlingspots.spot.RustlingSpotService;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class SpotSpawner {
    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        event.getServer().getAllLevels().forEach(this::trySpawnInLevel);
    }

    private void trySpawnInLevel(ServerLevel level) {
        if (level.getGameTime() % 20L != 0L) {
            return;
        }
        if (!RustlingSpotsServerConfig.GENERAL.enabled()) {
            return;
        }
        boolean allowedDimension = RustlingSpotsServerConfig.GENERAL.allowedDimensions().stream().map(Object::toString).map(ResourceLocation::tryParse).anyMatch(id -> id != null && id.equals((Object)level.dimension().location()));
        if (!allowedDimension) {
            return;
        }
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>(level.players());
        if (players.isEmpty()) {
            return;
        }
        RandomSource random = level.random;
        if (RustlingSpotService.MANAGER.getAll((ResourceKey<Level>)level.dimension()).size() >= RustlingSpotsServerConfig.GENERAL.maxSpotsPerDimension()) {
            return;
        }
        Set<ChunkPos> candidateChunks = this.collectCandidateChunks(players, random);
        if (candidateChunks.isEmpty()) {
            return;
        }
        ArrayList<ChunkPos> shuffled = new ArrayList<ChunkPos>(candidateChunks);
        Collections.shuffle(shuffled, new Random(random.nextLong()));
        double spawnDensity = RustlingSpotsServerConfig.GENERAL.spawnDensity();
        for (ChunkPos chunkPos : shuffled) {
            BlockState below;
            Optional<RustlingSpotFamily> family;
            BlockPos target;
            if (RustlingSpotService.MANAGER.getAll((ResourceKey<Level>)level.dimension()).size() >= RustlingSpotsServerConfig.GENERAL.maxSpotsPerDimension()) {
                return;
            }
            if (random.nextDouble() > spawnDensity || (target = this.pickSurface(level, chunkPos, random, players)) == null || (family = RustlingSpotFamily.fromSurfaceBlock(below = level.getBlockState(target.below()), (Level)level, target.below())).isEmpty() || !RustlingSpotService.MANAGER.hasSpace((ResourceKey<Level>)level.dimension(), chunkPos, RustlingSpotsServerConfig.GENERAL.maxSpotsPerDimension())) continue;
            double familyRate = RustlingSpotsFamilySpawnConfig.FAMILIES.spawnRate(family.get());
            if (random.nextDouble() > familyRate) continue;
            double minDistanceSq = RustlingSpotsServerConfig.GENERAL.minDistanceBetweenSpots() * RustlingSpotsServerConfig.GENERAL.minDistanceBetweenSpots();
            if (!RustlingSpotService.MANAGER.isFarEnough((ResourceKey<Level>)level.dimension(), minDistanceSq, target)) continue;
            int maxDistance = RustlingSpotsServerConfig.GENERAL.maxDistanceBetweenSpots();
            if (maxDistance > 0) {
                double nearestSq = RustlingSpotService.MANAGER.nearestDistanceSq((ResourceKey<Level>)level.dimension(), target);
                double maxDistanceSq = (double)maxDistance * (double)maxDistance;
                if (nearestSq > 0.0 && nearestSq > maxDistanceSq) continue;
            }
            UUID id2 = UUID.randomUUID();
            int variant = RustlingSoundEvents.indexForFamily(family.get());
            RustlingSpot spot = new RustlingSpot(id2, (ResourceKey<Level>)level.dimension(), target, family.get(), level.getGameTime(), variant);
            RustlingSpotService.MANAGER.add(spot);
            PacketDistributor.sendToPlayersInDimension((ServerLevel)level, (CustomPacketPayload)new RustlingSpotSpawnPacket(spot), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private Set<ChunkPos> collectCandidateChunks(List<ServerPlayer> players, RandomSource random) {
        int minDistance = Math.max(1, RustlingSpotsServerConfig.GENERAL.spawnMinDistanceFromPlayer());
        int maxDistance = Math.max(minDistance, RustlingSpotsServerConfig.GENERAL.spawnMaxDistanceFromPlayer());
        int minChunkRadius = Math.max(1, minDistance / 16);
        int maxChunkRadius = Math.max(minChunkRadius, (int)Math.ceil((double)maxDistance / 16.0));
        HashSet<ChunkPos> candidates = new HashSet<ChunkPos>();
        for (ServerPlayer player : players) {
            ChunkPos origin = player.chunkPosition();
            for (int dx = -maxChunkRadius; dx <= maxChunkRadius; ++dx) {
                for (int dz = -maxChunkRadius; dz <= maxChunkRadius; ++dz) {
                    int absDx = origin.x + dx;
                    int absDz = origin.z + dz;
                    ChunkPos pos = new ChunkPos(absDx, absDz);
                    double distance = player.position().distanceTo(Vec3.atCenterOf((Vec3i)pos.getMiddleBlockPosition(0)));
                    if (distance < (double)minDistance || distance > (double)maxDistance) continue;
                    candidates.add(pos);
                }
            }
        }
        return candidates;
    }

    private BlockPos pickSurface(ServerLevel level, ChunkPos chunkPos, RandomSource random, List<ServerPlayer> players) {
        int minDistance = Math.max(1, RustlingSpotsServerConfig.GENERAL.spawnMinDistanceFromPlayer());
        int maxDistance = Math.max(minDistance, RustlingSpotsServerConfig.GENERAL.spawnMaxDistanceFromPlayer());
        for (int attempt = 0; attempt < 8; ++attempt) {
            int x = chunkPos.getMinBlockX() + random.nextInt(16);
            int z = chunkPos.getMinBlockZ() + random.nextInt(16);
            BlockPos column = new BlockPos(x, level.getMaxBuildHeight() / 2, z);
            if (!level.hasChunkAt(column)) continue;
            BlockPos surface = level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, column);
            double closestPlayer = players.stream().mapToDouble(p -> p.position().distanceTo(Vec3.atCenterOf((Vec3i)surface))).min().orElse(Double.MAX_VALUE);
            if (closestPlayer < (double)minDistance || closestPlayer > (double)maxDistance) continue;
            return surface;
        }
        return null;
    }
}

