/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import io.netty.buffer.Unpooled;
import java.util.Map;
import net.mcreator.concoction.block.entity.CookingCauldronEntity;
import net.mcreator.concoction.init.ConcoctionModBlockEntities;
import net.mcreator.concoction.init.ConcoctionModSounds;
import net.mcreator.concoction.world.inventory.BoilingCauldronInterfaceMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class CookingCauldron
extends LayeredCauldronBlock
implements EntityBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty COOKING = BooleanProperty.create((String)"cooking");
    private long lastBoilingSoundTime = 0L;
    private static final long BOILING_SOUND_INTERVAL_MS = 2500L;

    public CookingCauldron(Biome.Precipitation precipitation, CauldronInteraction.InteractionMap interactions, BlockBehaviour.Properties properties) {
        super(precipitation, interactions, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)COOKING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIT, COOKING});
    }

    private boolean isHotBlock(BlockState state) {
        Block block = state.getBlock();
        return block instanceof FireBlock || block == Blocks.LAVA || block instanceof MagmaBlock || CampfireBlock.isLitCampfire((BlockState)state) || block == Blocks.SOUL_FIRE || block == Blocks.SOUL_CAMPFIRE;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        BlockState belowState = level.getBlockState(pos.below());
        boolean lit = this.isHotBlock(belowState);
        if (lit && !((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity entity;
        BlockState belowState;
        boolean lit;
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        if (fromPos.equals((Object)pos.below()) && (lit = this.isHotBlock(belowState = level.getBlockState(pos.below()))) != (Boolean)state.getValue((Property)LIT)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(lit)), 2);
        }
        if ((entity = level.getBlockEntity(pos)) instanceof CookingCauldronEntity) {
            CookingCauldronEntity cauldron = (CookingCauldronEntity)entity;
            cauldron.neighborChanged(state, level, pos, block, fromPos);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            LocalPlayer localPlayer;
            boolean isCooking = (Boolean)state.getValue((Property)COOKING);
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastBoilingSoundTime >= 2500L && (localPlayer = Minecraft.getInstance().player) != null) {
                double maxDistance;
                double dz;
                double dy;
                double dx = (double)pos.getX() + 0.5 - localPlayer.getX();
                double distanceSq = dx * dx + (dy = (double)pos.getY() + 0.5 - localPlayer.getY()) * dy + (dz = (double)pos.getZ() + 0.5 - localPlayer.getZ()) * dz;
                if (distanceSq < (maxDistance = 16.0) * maxDistance) {
                    double distance = Math.sqrt(distanceSq);
                    float volume = (float)Math.pow(1.0 - distance / maxDistance, 3.0);
                    volume = Math.max(0.0f, Math.min(volume, 1.0f));
                    level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (SoundEvent)ConcoctionModSounds.CAULDRON_BOILING.get(), SoundSource.BLOCKS, 0.6f * volume, rand.nextFloat() * 0.7f + 0.6f, false);
                }
                this.lastBoilingSoundTime = currentTime;
            }
            if (rand.nextInt(2) == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.BUBBLE, (double)pos.getX() + 0.5 + Math.pow(-1.0, rand.nextInt(2)) * (double)rand.nextFloat() / 3.0, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5 + Math.pow(-1.0, rand.nextInt(2)) * (double)rand.nextFloat() / 3.0, 0.0, 0.1, 0.0);
                level.addParticle((ParticleOptions)ParticleTypes.BUBBLE_POP, (double)pos.getX() + 0.5 + Math.pow(-1.0, rand.nextInt(2)) * (double)rand.nextFloat() / 4.0, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5 + Math.pow(-1.0, rand.nextInt(2)) * (double)rand.nextFloat() / 4.0, 0.0, 0.1, 0.0);
            }
            if (isCooking) {
                level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)pos.getX() + 0.5 + Math.pow(-1.0, rand.nextInt(2)) * (double)rand.nextFloat() / 4.0, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5 + Math.pow(-1.0, rand.nextInt(2)) * (double)rand.nextFloat() / 4.0, 0.0, 0.07, 0.0);
            }
        }
        super.animateTick(state, level, pos, rand);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CookingCauldronEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide() ? null : (type == ConcoctionModBlockEntities.COOKING_CAULDRON.get() ? (lvl, pos, st, entity) -> ((CookingCauldronEntity)entity).tick(lvl, pos, st) : null);
    }

    public ItemInteractionResult useItemOn(ItemStack item, BlockState state, Level level, final BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!player.isShiftKeyDown()) {
            MenuProvider containerProvider = new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"container.cooking_cauldron");
                }

                public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player playerEntity) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.writeBlockPos(pos);
                    return new BoilingCauldronInterfaceMenu(windowId, inventory, packetBuffer);
                }
            };
            player.openMenu(containerProvider, buf -> buf.writeBlockPos(pos));
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.CONSUME;
    }

    public Map<String, String> decreesItemCountFromResult(Map<String, String> result) {
        int newCount = Integer.parseInt(result.get("count")) - 1;
        if (newCount <= 0) {
            return Map.of("id", "", "count", "", "interactionType", "", "experience", "0");
        }
        return Map.of("id", result.get("id"), "count", String.valueOf(newCount), "interactionType", result.get("interactionType"), "experience", result.get("experience"));
    }

    public void onRemove(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Containers.dropContentsOnDestroy((BlockState)oldState, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(oldState, level, pos, newState, isMoving);
    }
}

