/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import java.util.Objects;
import javax.annotation.Nullable;
import net.mcreator.concoction.init.ConcoctionModBlocks;
import net.mcreator.concoction.init.ConcoctionModItems;
import net.mcreator.concoction.utils.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class CropCornBlock
extends CropBlock {
    public static final int FIRST_STAGE_MAX_AGE = 1;
    public static final int SECOND_STAGE_MAX_AGE = 1;
    public static final int THIRD_STAGE_MAX_AGE = 3;
    public static final int MAX_AGE = 5;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)5);
    public static final EnumProperty<PartProperty> PART = EnumProperty.create((String)"part", PartProperty.class);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)12.0, (double)14.0, (double)12.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public CropCornBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.NONE).sound(SoundType.GRASS).instabreak().noCollission().noOcclusion().randomTicks().pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue(PART, (Comparable)((Object)PartProperty.BOTTOM)));
    }

    public static boolean isReplaceableBlocksAround(Level pLevel, BlockPos pPos) {
        return BlockPos.betweenClosedStream((BlockPos)pPos.offset(-1, -2, -1), (BlockPos)pPos.offset(1, 2, 1)).map(arg_0 -> ((Level)pLevel).getBlockState(arg_0)).allMatch(pState -> !pState.is(BlockTags.FEATURES_CANNOT_REPLACE) && !pState.is((Block)ConcoctionModBlocks.CORN_BLOCK.get()));
    }

    public static void onLightningStrike(Level pLevel, BlockPos pPos, BlockState pState) {
        ServerLevel _serverworld;
        StructureTemplate template;
        if (pState.getValue(PART) == PartProperty.TOP && (Integer)pState.getValue((Property)AGE) == 5 && pLevel instanceof ServerLevel && (template = (_serverworld = (ServerLevel)pLevel).getStructureManager().getOrCreate(ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"charcoaled_corn"))) != null) {
            BlockPos placePos = pPos.offset(-1, -2, -1);
            template.placeInWorld((ServerLevelAccessor)_serverworld, placePos, placePos, new StructurePlaceSettings().setRotation(Rotation.NONE).setMirror(Mirror.NONE).setIgnoreEntities(false).addProcessor((StructureProcessor)new ProtectedBlockProcessor(BlockTags.FEATURES_CANNOT_REPLACE)), _serverworld.random, 3);
            ((ServerLevel)pLevel).getPlayers(player -> player.distanceToSqr((double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ()) <= 256.0).forEach(player -> Utils.addAchievement(player, "concoction:giant_corn_witness"));
        }
    }

    public boolean isRandomlyTicking(BlockState p_52288_) {
        return !this.isMaxAge(p_52288_);
    }

    public void changeAge(BlockState pState, ServerLevel pLevel, BlockPos pPos, int nextAge) {
        if (nextAge <= 1) {
            pLevel.setBlock(pPos, this.getState(pState, nextAge, PartProperty.BOTTOM), 2);
        } else if (nextAge == 2 && pLevel.getBlockState(pPos.above()).is(Blocks.AIR)) {
            pLevel.setBlock(pPos, this.getState(pState, nextAge, PartProperty.BOTTOM), 2);
            pLevel.setBlock(pPos.above(), this.getState(pState, nextAge, PartProperty.MIDDLE), 2);
        } else if (nextAge > 2 && (pLevel.getBlockState(pPos.above()).is(Blocks.AIR) || pLevel.getBlockState(pPos.above()).is((Block)this)) && (pLevel.getBlockState(pPos.above(2)).is(Blocks.AIR) || pLevel.getBlockState(pPos.above(2)).is((Block)this))) {
            pLevel.setBlock(pPos, this.getState(pState, nextAge, PartProperty.BOTTOM), 2);
            pLevel.setBlock(pPos.above(1), this.getState(pState, nextAge, PartProperty.MIDDLE), 2);
            pLevel.setBlock(pPos.above(2), this.getState(pState, nextAge, PartProperty.TOP), 2);
        }
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource random) {
        float f;
        int nextAge;
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (pLevel.getRawBrightness(pPos, 0) >= 9 && pState.getValue(PART) == PartProperty.BOTTOM && (nextAge = this.getAge(pState) + 1) <= this.getMaxAge() && CommonHooks.canCropGrow((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (random.nextInt((int)(25.0f / (f = CropCornBlock.getGrowthSpeed((BlockState)pState, (BlockGetter)pLevel, (BlockPos)pPos))) + 1) == 0 ? 1 : 0) != 0)) {
            this.changeAge(pState, pLevel, pPos, nextAge);
            CommonHooks.fireCropGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public BlockState getState(BlockState pState, int age, PartProperty part) {
        return (BlockState)((BlockState)pState.setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age))).setValue(PART, (Comparable)((Object)part));
    }

    public void growCrops(Level pLevel, BlockPos pPos, BlockState pState) {
        BlockPos bottomPos;
        BlockState bottomState;
        PartProperty currentPart;
        int maxAge;
        int nextAge = this.getAge(pState) + this.getBonemealAgeIncrease(pLevel);
        if (nextAge > (maxAge = this.getMaxAge())) {
            nextAge = maxAge;
        }
        if ((currentPart = (PartProperty)((Object)pState.getValue(PART))) == PartProperty.BOTTOM) {
            this.changeAge(pState, (ServerLevel)pLevel, pPos, nextAge);
        } else if (currentPart == PartProperty.MIDDLE) {
            BlockPos bottomPos2 = pPos.below();
            BlockState bottomState2 = pLevel.getBlockState(bottomPos2);
            if (bottomState2.is((Block)this)) {
                this.changeAge(bottomState2, (ServerLevel)pLevel, bottomPos2, nextAge);
            }
        } else if (currentPart == PartProperty.TOP && (bottomState = pLevel.getBlockState(bottomPos = pPos.below(2))).is((Block)this)) {
            this.changeAge(bottomState, (ServerLevel)pLevel, bottomPos, nextAge);
        }
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return ((Integer)pState.getValue((Property)AGE)).intValue() != this.getMaxAge();
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        if (pState.getValue(PART) == PartProperty.BOTTOM) {
            if ((Integer)pState.getValue((Property)AGE) <= 1) {
                return super.canSurvive(pState, pLevel, pPos);
            }
            if ((Integer)pState.getValue((Property)AGE) == 2) {
                return super.canSurvive(pState, pLevel, pPos) && this.isValidCorn(pLevel, pPos.above(1), (Integer)pState.getValue((Property)AGE), PartProperty.MIDDLE);
            }
            if ((Integer)pState.getValue((Property)AGE) > 2) {
                return super.canSurvive(pState, pLevel, pPos) && this.isValidCorn(pLevel, pPos.above(1), (Integer)pState.getValue((Property)AGE), PartProperty.MIDDLE);
            }
            return false;
        }
        if (pState.getValue(PART) == PartProperty.MIDDLE) {
            if ((Integer)pState.getValue((Property)AGE) <= 1) {
                return false;
            }
            if ((Integer)pState.getValue((Property)AGE) == 2) {
                return super.canSurvive(pState, pLevel, pPos) || this.isValidCorn(pLevel, pPos.below(1), (Integer)pState.getValue((Property)AGE), PartProperty.BOTTOM);
            }
            if ((Integer)pState.getValue((Property)AGE) > 2) {
                return super.canSurvive(pState, pLevel, pPos) || this.isValidCorn(pLevel, pPos.below(1), (Integer)pState.getValue((Property)AGE), PartProperty.BOTTOM) && this.isValidCorn(pLevel, pPos.above(1), (Integer)pState.getValue((Property)AGE), PartProperty.TOP);
            }
            return false;
        }
        if (pState.getValue(PART) == PartProperty.TOP) {
            if ((Integer)pState.getValue((Property)AGE) <= 2) {
                return false;
            }
            if ((Integer)pState.getValue((Property)AGE) > 2) {
                return super.canSurvive(pState, pLevel, pPos) || this.isValidCorn(pLevel, pPos.below(1), (Integer)pState.getValue((Property)AGE), PartProperty.MIDDLE);
            }
            return false;
        }
        return this.canSurvive(pState, pLevel, pPos);
    }

    public boolean isValidCorn(LevelReader pLevel, BlockPos pPos, int needAge, PartProperty needPart) {
        BlockState pState = pLevel.getBlockState(pPos);
        return pState.is((Block)this) && pState.getValue(PART) == needPart;
    }

    public boolean mayPlaceOn(BlockState pState, BlockGetter p_52303_, BlockPos p_52304_) {
        return (pState.is(BlockTags.DIRT) || pState.getBlock() instanceof FarmBlock) && !(pState.getBlock() instanceof CropCornBlock);
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player player) {
        if (!pLevel.isClientSide) {
            if (player.isCreative()) {
                CropCornBlock.breakBlock(false, pLevel, pPos, pState, player);
            } else {
                CropCornBlock.breakBlock(true, pLevel, pPos, pState, player);
            }
        }
        return super.playerWillDestroy(pLevel, pPos, pState, player);
    }

    public void playerDestroy(Level p_52865_, Player p_52866_, BlockPos p_52867_, BlockState p_52868_, @Nullable BlockEntity p_52869_, ItemStack p_52870_) {
        super.playerDestroy(p_52865_, p_52866_, p_52867_, Blocks.AIR.defaultBlockState(), p_52869_, p_52870_);
    }

    protected static void breakBlock(boolean dropItems, Level pLevel, BlockPos pPos, BlockState pState, Player player) {
        PartProperty blockPart = (PartProperty)((Object)pState.getValue(PART));
        if (blockPart == PartProperty.MIDDLE) {
            BlockPos blockpos = pPos.below();
            BlockState blockstate = pLevel.getBlockState(blockpos);
            if (blockstate.is(pState.getBlock()) && blockstate.getValue(PART) == PartProperty.BOTTOM) {
                BlockState blockstate1 = blockstate.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
                pLevel.setBlock(blockpos, blockstate1, 35);
                pLevel.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
                if (dropItems) {
                    CropCornBlock.dropResources((BlockState)blockstate, (Level)pLevel, (BlockPos)blockpos, null, (Entity)player, (ItemStack)player.getMainHandItem());
                }
            }
        } else if (blockPart == PartProperty.TOP) {
            BlockState blockstate1 = pLevel.getBlockState(pPos.below(1));
            BlockState blockstate2 = pLevel.getBlockState(pPos.below(2));
            if (blockstate1.is(pState.getBlock()) && blockstate1.getValue(PART) == PartProperty.MIDDLE && blockstate2.is(pState.getBlock()) && blockstate2.getValue(PART) == PartProperty.BOTTOM) {
                BlockState replaceBlockState1 = blockstate1.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
                BlockState replaceBlockState2 = blockstate2.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
                pLevel.setBlock(pPos.below(1), replaceBlockState1, 35);
                pLevel.setBlock(pPos.below(2), replaceBlockState2, 35);
                pLevel.levelEvent(player, 2001, pPos.below(2), Block.getId((BlockState)blockstate2));
                if (dropItems) {
                    CropCornBlock.dropResources((BlockState)blockstate2, (Level)pLevel, (BlockPos)pPos.below(2), null, (Entity)player, (ItemStack)player.getMainHandItem());
                }
            }
        } else if (dropItems) {
            CropCornBlock.dropResources((BlockState)pState, (Level)pLevel, (BlockPos)pPos, null, (Entity)player, (ItemStack)player.getMainHandItem());
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack pItem, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand p_316595_, BlockHitResult p_316140_) {
        if (!pPlayer.isShiftKeyDown() && (Integer)pState.getValue((Property)AGE) == 5 && ((PartProperty)((Object)pState.getValue(PART))).equals((Object)PartProperty.MIDDLE)) {
            if (pLevel instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)pLevel;
                pLevel.setBlock(pPos.below(1), this.getState(pState, 3, PartProperty.BOTTOM), 2);
                pLevel.setBlock(pPos, this.getState(pState, 3, PartProperty.MIDDLE), 2);
                pLevel.setBlock(pPos.above(1), this.getState(pState, 3, PartProperty.TOP), 2);
                if (!_level.isClientSide()) {
                    _level.playSound(null, pPos, Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.cave_vines.pick_berries"))), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(pPos, Objects.requireNonNull((SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.cave_vines.pick_berries"))), SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
                ItemEntity entityToSpawn = new ItemEntity((Level)_level, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, new ItemStack((ItemLike)ConcoctionModItems.CORN.get(), 2));
                entityToSpawn.setPickUpDelay(10);
                _level.addFreshEntity((Entity)entityToSpawn);
                if (Math.random() < 0.5) {
                    ItemEntity AdditEntityToSpawn = new ItemEntity((Level)_level, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, new ItemStack((ItemLike)ConcoctionModItems.CORN.get()));
                    AdditEntityToSpawn.setPickUpDelay(10);
                    _level.addFreshEntity((Entity)AdditEntityToSpawn);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(pItem, pState, pLevel, pPos, pPlayer, p_316595_, p_316140_);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_AGE[this.getAge(pState)];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, PART});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue(PART, (Comparable)((Object)PartProperty.BOTTOM));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ConcoctionModItems.CORN_SEEDS.get());
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.OPEN;
    }

    public int getMaxAge() {
        return 5;
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public ItemLike getBaseSeedId() {
        return (ItemLike)ConcoctionModItems.CORN_SEEDS.get();
    }

    public static enum PartProperty implements StringRepresentable
    {
        BOTTOM("bottom"),
        MIDDLE("middle"),
        TOP("top");

        private final String name;

        private PartProperty(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

