/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import com.mojang.serialization.MapCodec;
import net.mcreator.concoction.init.ConcoctionModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;

public class RiceBlockBlock
extends FallingBlock {
    public static final MapCodec<RiceBlockBlock> CODEC = RiceBlockBlock.simpleCodec(properties -> new RiceBlockBlock());
    private static final Direction[] ALL_DIRECTIONS = Direction.values();

    public MapCodec<RiceBlockBlock> codec() {
        return CODEC;
    }

    public RiceBlockBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).sound(SoundType.SAND).strength(0.5f));
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    public void onLand(Level p_52068_, BlockPos p_52069_, BlockState p_52070_, BlockState p_52071_, FallingBlockEntity p_52072_) {
        if (RiceBlockBlock.shouldSolidify((BlockGetter)p_52068_, p_52069_, p_52070_, p_52071_.getFluidState()) || RiceBlockBlock.touchesLiquid((BlockGetter)p_52068_, p_52069_, p_52070_)) {
            p_52068_.setBlock(p_52069_, ((Block)ConcoctionModBlocks.SOAKED_RICE_BLOCK.get()).defaultBlockState(), 128);
        }
    }

    protected BlockState updateShape(BlockState p_52074_, Direction p_52075_, BlockState p_52076_, LevelAccessor p_52077_, BlockPos p_52078_, BlockPos p_52079_) {
        return RiceBlockBlock.touchesLiquid((BlockGetter)p_52077_, p_52078_, p_52074_) ? ((Block)ConcoctionModBlocks.SOAKED_RICE_BLOCK.get()).defaultBlockState() : super.updateShape(p_52074_, p_52075_, p_52076_, p_52077_, p_52078_, p_52079_);
    }

    protected void onPlace(BlockState p_56811_, Level p_56812_, BlockPos p_56813_, BlockState p_56814_, boolean p_56815_) {
        if (!p_56814_.is(p_56811_.getBlock())) {
            RiceBlockBlock.tryAbsorbWater(p_56812_, p_56813_, this);
        }
        super.onPlace(p_56811_, p_56812_, p_56813_, p_56814_, p_56815_);
    }

    protected void neighborChanged(BlockState p_56801_, Level p_56802_, BlockPos p_56803_, Block p_56804_, BlockPos p_56805_, boolean p_56806_) {
        RiceBlockBlock.tryAbsorbWater(p_56802_, p_56803_, this);
        super.neighborChanged(p_56801_, p_56802_, p_56803_, p_56804_, p_56805_, p_56806_);
    }

    public static boolean touchesLiquid(BlockGetter level, BlockPos blockPos, BlockState state) {
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = blockPos.mutable();
        for (Direction direction : Direction.values()) {
            BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (direction == Direction.DOWN && !state.canBeHydrated(level, blockPos, blockstate.getFluidState(), (BlockPos)blockpos$mutableblockpos)) continue;
            blockpos$mutableblockpos.setWithOffset((Vec3i)blockPos, direction);
            blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (!state.canBeHydrated(level, blockPos, blockstate.getFluidState(), (BlockPos)blockpos$mutableblockpos) || blockstate.isFaceSturdy(level, blockPos, direction.getOpposite())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean shouldSolidify(BlockGetter level, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        return blockState.canBeHydrated(level, blockPos, fluidState, blockPos) || RiceBlockBlock.touchesLiquid(level, blockPos, blockState);
    }

    public static void tryAbsorbWater(Level level, BlockPos blockPos, RiceBlockBlock block) {
        if (RiceBlockBlock.removeWaterBreadthFirstSearch(level, blockPos, block)) {
            level.setBlock(blockPos, ((Block)ConcoctionModBlocks.SOAKED_RICE_BLOCK.get()).defaultBlockState(), 2);
            level.playSound((Player)null, blockPos, SoundEvents.SPONGE_ABSORB, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static boolean removeWaterBreadthFirstSearch(Level level, BlockPos blockPos, RiceBlockBlock block) {
        BlockState spongeState = level.getBlockState(blockPos);
        return BlockPos.breadthFirstTraversal((BlockPos)blockPos, (int)3, (int)10, (p_277519_, p_277492_) -> {
            for (Direction direction : ALL_DIRECTIONS) {
                p_277492_.accept(p_277519_.relative(direction));
            }
        }, p_294069_ -> {
            BucketPickup bucketpickup;
            if (p_294069_.equals((Object)blockPos)) {
                return true;
            }
            BlockState blockstate = level.getBlockState(p_294069_);
            FluidState fluidstate = level.getFluidState(p_294069_);
            if (!spongeState.canBeHydrated((BlockGetter)level, blockPos, fluidstate, p_294069_)) {
                return false;
            }
            Block patt0$temp = blockstate.getBlock();
            if (patt0$temp instanceof BucketPickup && !(bucketpickup = (BucketPickup)patt0$temp).pickupBlock((Player)null, (LevelAccessor)level, p_294069_, blockstate).isEmpty()) {
                return true;
            }
            if (blockstate.getBlock() instanceof LiquidBlock) {
                level.setBlock(p_294069_, Blocks.AIR.defaultBlockState(), 5);
            } else {
                if (!(blockstate.is(Blocks.KELP) || blockstate.is(Blocks.KELP_PLANT) || blockstate.is(Blocks.SEAGRASS) || blockstate.is(Blocks.TALL_SEAGRASS))) {
                    return false;
                }
                BlockEntity blockentity = blockstate.hasBlockEntity() ? level.getBlockEntity(p_294069_) : null;
                RiceBlockBlock.dropResources((BlockState)blockstate, (LevelAccessor)level, (BlockPos)p_294069_, (BlockEntity)blockentity);
                level.setBlock(p_294069_, Blocks.AIR.defaultBlockState(), 3);
            }
            return true;
        }) > 1;
    }
}

