/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import com.mojang.serialization.MapCodec;
import net.mcreator.concoction.init.ConcoctionModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class SoakedRiceBlockBlock
extends FallingBlock {
    public static final MapCodec<SoakedRiceBlockBlock> CODEC = SoakedRiceBlockBlock.simpleCodec(properties -> new SoakedRiceBlockBlock());

    public MapCodec<SoakedRiceBlockBlock> codec() {
        return CODEC;
    }

    public SoakedRiceBlockBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).sound(SoundType.WET_SPONGE).strength(0.5f));
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (level.dimensionType().ultraWarm()) {
            level.setBlock(pos, ((Block)ConcoctionModBlocks.RICE_BLOCK.get()).defaultBlockState(), 3);
            level.levelEvent(2009, pos, 0);
            level.playSound((Player)null, pos, SoundEvents.WET_SPONGE_DRIES, SoundSource.BLOCKS, 1.0f, (1.0f + level.getRandom().nextFloat() * 0.2f) * 0.7f);
        } else {
            level.scheduleTick(pos, (Block)this, this.getDelayAfterPlace());
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction direction = Direction.getRandom((RandomSource)random);
        if (direction != Direction.UP) {
            BlockPos neighborPos = pos.relative(direction);
            BlockState neighborState = level.getBlockState(neighborPos);
            if (!state.canOcclude() || !neighborState.isFaceSturdy((BlockGetter)level, neighborPos, direction.getOpposite())) {
                double x = pos.getX();
                double y = pos.getY();
                double z = pos.getZ();
                if (direction == Direction.DOWN) {
                    y -= 0.05;
                    x += random.nextDouble();
                    z += random.nextDouble();
                } else {
                    y += random.nextDouble() * 0.8;
                    if (direction.getAxis() == Direction.Axis.X) {
                        z += random.nextDouble();
                        x += direction == Direction.EAST ? 1.0 : 0.05;
                    } else {
                        x += random.nextDouble();
                        z += direction == Direction.SOUTH ? 1.0 : 0.05;
                    }
                }
                level.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }
}

