/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.mcreator.concoction.init.ConcoctionModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.FarmlandWaterManager;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="concoction")
public class SoullandBlock
extends Block {
    public static final BooleanProperty SOULCHARGED = BooleanProperty.create((String)"soulcharged");
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);

    public SoullandBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BROWN).sound(SoundType.SOUL_SOIL).strength(0.5f).randomTicks().isRedstoneConductor((bs, br, bp) -> false).lightLevel(state -> (Boolean)state.getValue((Property)SOULCHARGED) != false ? 3 : 0).emissiveRendering((state, world, pos) -> (Boolean)state.getValue((Property)SOULCHARGED)));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)SOULCHARGED, (Comparable)Boolean.valueOf(false)));
    }

    @SubscribeEvent
    public static void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        ServerPlayer player;
        Player player2;
        if (!event.getLevel().isClientSide && (player2 = event.getEntity()) instanceof ServerPlayer && (player = (ServerPlayer)player2).getMainHandItem().is(ItemTags.HOES)) {
            BlockPos pos = event.getPos();
            Level world = event.getLevel();
            if (world.getBlockState(pos).is(Blocks.SOUL_SOIL)) {
                SoullandBlock.turnToSoil((Entity)player, world.getBlockState(pos), world, pos);
            }
        }
    }

    protected BlockState updateShape(BlockState p_53276_, Direction p_53277_, BlockState p_53278_, LevelAccessor p_53279_, BlockPos p_53280_, BlockPos p_53281_) {
        if (p_53277_ == Direction.UP && !p_53276_.canSurvive((LevelReader)p_53279_, p_53280_)) {
            p_53279_.scheduleTick(p_53280_, (Block)this, 1);
        }
        return super.updateShape(p_53276_, p_53277_, p_53278_, p_53279_, p_53280_, p_53281_);
    }

    public boolean canSurvive(BlockState p_53272_, LevelReader p_53273_, BlockPos p_53274_) {
        BlockState blockstate = p_53273_.getBlockState(p_53274_.above());
        return !blockstate.isSolid() || blockstate.getBlock() instanceof FenceGateBlock || blockstate.getBlock() instanceof MovingPistonBlock;
    }

    public void tick(BlockState p_221134_, ServerLevel p_221135_, BlockPos p_221136_, RandomSource p_221137_) {
        if (!p_221134_.canSurvive((LevelReader)p_221135_, p_221136_)) {
            SoullandBlock.turnToSoil(null, p_221134_, (Level)p_221135_, p_221136_);
        }
    }

    public void randomTick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        block7: {
            boolean charged;
            block5: {
                block6: {
                    super.randomTick(blockstate, world, pos, random);
                    charged = (Boolean)blockstate.getValue((Property)SOULCHARGED);
                    boolean nearSoul = SoullandBlock.isNearSoul((LevelReader)world, pos);
                    if (nearSoul) break block5;
                    if (!charged) break block6;
                    world.setBlock(pos, (BlockState)blockstate.setValue((Property)SOULCHARGED, (Comparable)Boolean.valueOf(false)), 2);
                    break block7;
                }
                if (SoullandBlock.shouldMaintainFarmland((BlockGetter)world, pos)) break block7;
                SoullandBlock.turnToSoil(null, blockstate, (Level)world, pos);
                break block7;
            }
            if (!charged) {
                world.setBlock(pos, (BlockState)blockstate.setValue((Property)SOULCHARGED, (Comparable)Boolean.valueOf(true)), 2);
            }
            if (charged) {
                for (BlockPos offset : BlockPos.betweenClosed((BlockPos)pos.offset(-4, 1, -4), (BlockPos)pos.offset(4, 2, 4))) {
                    BlockState cropState = world.getBlockState(offset);
                    BlockState belowState = world.getBlockState(offset.below());
                    if (!(cropState.getBlock() instanceof CropBlock) || !(belowState.getBlock() instanceof SoullandBlock) || !(random.nextFloat() < 0.16f)) continue;
                    try {
                        Method randomTickMethod = CropBlock.class.getDeclaredMethod("randomTick", BlockState.class, ServerLevel.class, BlockPos.class, RandomSource.class);
                        randomTickMethod.setAccessible(true);
                        randomTickMethod.invoke((Object)cropState.getBlock(), cropState, world, offset, random);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void fallOn(Level p_153227_, BlockState p_153228_, BlockPos p_153229_, Entity p_153230_, float p_153231_) {
        if (!p_153227_.isClientSide && CommonHooks.onFarmlandTrample((Level)p_153227_, (BlockPos)p_153229_, (BlockState)Blocks.SOUL_SOIL.defaultBlockState(), (float)p_153231_, (Entity)p_153230_)) {
            SoullandBlock.turnToSoil(p_153230_, p_153228_, p_153227_, p_153229_);
        }
        super.fallOn(p_153227_, p_153228_, p_153229_, p_153230_, p_153231_);
    }

    public static void turnToSoil(@Nullable Entity p_270981_, BlockState p_270402_, Level p_270568_, BlockPos p_270551_) {
        BlockState blockstate = SoullandBlock.pushEntitiesUp((BlockState)p_270402_, (BlockState)Blocks.SOUL_SOIL.defaultBlockState(), (LevelAccessor)p_270568_, (BlockPos)p_270551_);
        p_270568_.setBlockAndUpdate(p_270551_, blockstate);
        p_270568_.gameEvent((Holder)GameEvent.BLOCK_CHANGE, p_270551_, GameEvent.Context.of((Entity)p_270981_, (BlockState)blockstate));
    }

    private static boolean shouldMaintainFarmland(BlockGetter p_279219_, BlockPos p_279209_) {
        return p_279219_.getBlockState(p_279209_.above()).is(BlockTags.MAINTAINS_FARMLAND);
    }

    private static boolean isNearSoul(LevelReader level, BlockPos pPos) {
        BlockState state = level.getBlockState(pPos);
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pPos.offset(-4, 0, -4), (BlockPos)pPos.offset(4, 1, 4))) {
            if (!level.getBlockState(blockpos).getBlock().equals(ConcoctionModBlocks.WEIGHTED_SOULS.get())) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)level, (BlockPos)pPos);
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SOULCHARGED});
    }

    public boolean isPathfindable(BlockState p_53267_, PathComputationType p_53270_) {
        return false;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)SOULCHARGED, (Comparable)Boolean.valueOf(false));
    }
}

