/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block.entity;

import com.google.gson.Gson;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mcreator.concoction.block.CookingCauldron;
import net.mcreator.concoction.init.ConcoctionModBlockEntities;
import net.mcreator.concoction.init.ConcoctionModRecipes;
import net.mcreator.concoction.recipe.cauldron.CauldronBrewingRecipe;
import net.mcreator.concoction.recipe.cauldron.CauldronBrewingRecipeInput;
import net.mcreator.concoction.world.inventory.BoilingCauldronInterfaceMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class CookingCauldronEntity
extends RandomizableContainerBlockEntity {
    private final int ContainerSize = 6;
    private boolean isCooking = false;
    private RecipeHolder<CauldronBrewingRecipe> recipe = null;
    private Map<String, String> craftResult = Map.ofEntries(Map.entry("id", ""), Map.entry("count", ""), Map.entry("interactionType", ""));
    private int progress = 0;
    private int maxProgress = 200;
    private final int DEFAULT_MAX_PROGRESS = 200;
    private NonNullList<ItemStack> items = NonNullList.withSize((int)this.ContainerSize, (Object)ItemStack.EMPTY);

    public CookingCauldronEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ConcoctionModBlockEntities.COOKING_CAULDRON.get(), pos, state);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.progress = tag.getInt("cooking.progress");
        this.maxProgress = tag.getInt("cooking.max_progress");
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        this.craftResult = (Map)new Gson().fromJson(tag.getString("cooking.craft_result"), HashMap.class);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("cooking.progress", this.progress);
        tag.putInt("cooking.max_progress", this.maxProgress);
        tag.putString("cooking.craft_result", new Gson().toJson(this.craftResult));
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos) {
        if (fromPos.equals((Object)pos.below())) {
            this.checkHeatSource(level, pos, state);
        }
    }

    private void checkHeatSource(Level level, BlockPos pos, BlockState state) {
        boolean hasHeatSource;
        if (level.isClientSide) {
            return;
        }
        Block blockBelow = level.getBlockState(pos.below()).getBlock();
        boolean bl = hasHeatSource = level.getFluidState(pos.below()).is(Fluids.LAVA.getSource()) || blockBelow instanceof FireBlock || blockBelow instanceof MagmaBlock || blockBelow instanceof CampfireBlock;
        if (!hasHeatSource) {
            if (((Boolean)state.getValue((Property)CookingCauldron.LIT)).booleanValue() || ((Boolean)state.getValue((Property)CookingCauldron.COOKING)).booleanValue()) {
                BlockState defaultState = (BlockState)state.getBlock().defaultBlockState().setValue((Property)CookingCauldron.LEVEL, (Comparable)((Integer)state.getValue((Property)CookingCauldron.LEVEL)));
                level.setBlock(pos, defaultState, 3);
                this.resetProgress();
            }
        } else if (!((Boolean)state.getValue((Property)CookingCauldron.LIT)).booleanValue()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)CookingCauldron.LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void tick(Level level, BlockPos pPos, BlockState pState) {
        if (!level.isClientSide) {
            this.checkHeatSource(level, pPos, pState);
            if (((Boolean)pState.getValue((Property)CookingCauldron.LIT)).booleanValue()) {
                if (this.isCooking) {
                    String recipeResultId;
                    ItemStack resultSlot;
                    if (!this.validateCurrentRecipe()) {
                        level.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)CookingCauldron.COOKING, (Comparable)Boolean.valueOf(false)));
                        this.resetProgress();
                        return;
                    }
                    if (this.recipe != null && !(resultSlot = (ItemStack)this.items.get(5)).isEmpty() && !(recipeResultId = ((CauldronBrewingRecipe)this.recipe.value()).getOutput().get("id")).isEmpty()) {
                        int recipeCount;
                        ResourceLocation recipeItemId = ResourceLocation.parse((String)recipeResultId);
                        ResourceLocation currentItemId = BuiltInRegistries.ITEM.getKey((Object)resultSlot.getItem());
                        if (!currentItemId.equals((Object)recipeItemId)) {
                            level.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)CookingCauldron.COOKING, (Comparable)Boolean.valueOf(false)));
                            this.resetProgress();
                            return;
                        }
                        int currentCount = resultSlot.getCount();
                        if (currentCount + (recipeCount = Integer.parseInt(((CauldronBrewingRecipe)this.recipe.value()).getOutput().get("count"))) > resultSlot.getMaxStackSize()) {
                            level.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)CookingCauldron.COOKING, (Comparable)Boolean.valueOf(false)));
                            this.resetProgressOnly();
                            return;
                        }
                    }
                    this.increaseCraftingProgress();
                    CookingCauldronEntity.setChanged((Level)level, (BlockPos)pPos, (BlockState)pState);
                    if (this.hasCraftingFinished()) {
                        this.craftItem();
                        level.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)CookingCauldron.COOKING, (Comparable)Boolean.valueOf(false)));
                    }
                } else if (!this.hasCraftedResult() && this.hasRecipe()) {
                    level.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)CookingCauldron.COOKING, (Comparable)Boolean.valueOf(true)));
                    this.isCooking = true;
                    CookingCauldronEntity.setChanged((Level)level, (BlockPos)pPos, (BlockState)pState);
                }
            } else {
                level.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)CookingCauldron.COOKING, (Comparable)Boolean.valueOf(false)));
                this.resetProgress();
            }
        }
    }

    private boolean validateCurrentRecipe() {
        ItemStack ladleStack;
        if (this.recipe == null) {
            return false;
        }
        String interactionType = ((CauldronBrewingRecipe)this.recipe.value()).getOutput().get("interactionType");
        if (!interactionType.equals("hand") && (ladleStack = (ItemStack)this.items.get(4)).isEmpty()) {
            return false;
        }
        HashMap<Ingredient, Integer> requiredIngredients = new HashMap<Ingredient, Integer>();
        for (Ingredient ingredient : ((CauldronBrewingRecipe)this.recipe.value()).getInputItems()) {
            requiredIngredients.merge(ingredient, 1, Integer::sum);
        }
        block1: for (ItemStack itemStack : this.items.subList(0, 4)) {
            if (itemStack.isEmpty()) continue;
            for (Map.Entry entry : requiredIngredients.entrySet()) {
                if ((Integer)entry.getValue() <= 0 || !((Ingredient)entry.getKey()).test(itemStack)) continue;
                entry.setValue((Integer)entry.getValue() - 1);
                continue block1;
            }
        }
        return requiredIngredients.values().stream().allMatch(count -> count <= 0);
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = this.recipe == null ? 200 : ((CauldronBrewingRecipe)this.recipe.value()).getCookingTime();
        this.isCooking = false;
        this.recipe = null;
        this.craftResult = Map.of("id", "", "count", "", "interactionType", "");
        this.setChanged();
    }

    private void resetProgressOnly() {
        this.progress = 0;
        this.isCooking = false;
        this.setChanged();
    }

    /*
     * WARNING - void declaration
     */
    private void craftItem() {
        Object remainingStack;
        HashMap<Ingredient, Integer> requiredIngredients = new HashMap<Ingredient, Integer>();
        for (Ingredient ingredient : ((CauldronBrewingRecipe)this.recipe.value()).getInputItems()) {
            requiredIngredients.merge(ingredient, 1, Integer::sum);
        }
        NonNullList newItems = NonNullList.withSize((int)this.ContainerSize, (Object)ItemStack.EMPTY);
        ArrayList<ItemStack> itemsToSpawn = new ArrayList<ItemStack>();
        for (int i = 0; i < 4; ++i) {
            ItemStack itemStack = (ItemStack)this.items.get(i);
            if (itemStack.isEmpty()) continue;
            boolean used = false;
            for (Map.Entry entry : requiredIngredients.entrySet()) {
                if ((Integer)entry.getValue() <= 0 || !((Ingredient)entry.getKey()).test(itemStack)) continue;
                entry.setValue((Integer)entry.getValue() - 1);
                used = true;
                if (itemStack.getCount() <= 1) break;
                if (itemStack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:buckets")))) {
                    itemsToSpawn.add(new ItemStack((ItemLike)Items.BUCKET));
                    break;
                }
                if (!itemStack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:bottles")))) break;
                itemsToSpawn.add(new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                break;
            }
            if (used && itemStack.getCount() <= 1) continue;
            remainingStack = itemStack.copy();
            if (used) {
                remainingStack.shrink(1);
            }
            newItems.set(i, remainingStack);
        }
        String interactionType = ((CauldronBrewingRecipe)this.recipe.value()).getOutput().get("interactionType");
        if (!interactionType.equals("hand")) {
            ItemStack ladleStack = (ItemStack)this.items.get(4);
            if (!ladleStack.isEmpty()) {
                boolean isCorrectLadleItem;
                void var8_17;
                remainingStack = interactionType;
                int n = -1;
                switch (((String)remainingStack).hashCode()) {
                    case -1383228986: {
                        if (!((String)remainingStack).equals("bottle")) break;
                        boolean bl = false;
                        break;
                    }
                    case 109764752: {
                        if (!((String)remainingStack).equals("stick")) break;
                        boolean bl = true;
                        break;
                    }
                    case -1378203158: {
                        if (!((String)remainingStack).equals("bucket")) break;
                        int n2 = 2;
                        break;
                    }
                    case 3029986: {
                        if (!((String)remainingStack).equals("bowl")) break;
                        int n3 = 3;
                    }
                }
                switch (var8_17) {
                    case 0: {
                        boolean bl;
                        if (ladleStack.getItem() == Items.GLASS_BOTTLE) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 1: {
                        boolean bl;
                        if (ladleStack.getItem() == Items.STICK) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 2: {
                        boolean bl;
                        if (ladleStack.getItem() == Items.BUCKET) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 3: {
                        boolean bl;
                        if (ladleStack.getItem() == Items.BOWL) {
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    default: {
                        boolean bl = isCorrectLadleItem = false;
                    }
                }
                if (isCorrectLadleItem && ladleStack.getCount() > 1) {
                    ItemStack remainingLadle = ladleStack.copy();
                    remainingLadle.shrink(1);
                    newItems.set(4, (Object)remainingLadle);
                }
            }
        } else {
            newItems.set(4, (Object)((ItemStack)this.items.get(4)).copy());
        }
        this.craftResult = ((CauldronBrewingRecipe)this.recipe.value()).getOutput();
        if (!this.craftResult.get("id").isEmpty()) {
            void var8_20;
            ResourceLocation itemId = ResourceLocation.parse((String)this.craftResult.get("id"));
            int craftedCount = Integer.parseInt(this.craftResult.get("count"));
            ItemStack currentResult = (ItemStack)this.items.get(5);
            if (!currentResult.isEmpty() && currentResult.is((Item)BuiltInRegistries.ITEM.get(itemId))) {
                ItemStack itemStack = currentResult.copy();
                int spaceLeft = itemStack.getMaxStackSize() - itemStack.getCount();
                int toAdd = Math.min(craftedCount, spaceLeft);
                if (toAdd > 0) {
                    itemStack.grow(toAdd);
                }
            } else {
                ItemStack itemStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(itemId), craftedCount);
            }
            newItems.set(5, (Object)var8_20);
        }
        this.setItems((NonNullList<ItemStack>)newItems);
        if (!itemsToSpawn.isEmpty() && this.level != null) {
            for (ItemStack stack : itemsToSpawn) {
                Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)stack);
            }
        }
        if (this.hasRecipe()) {
            this.resetProgressOnly();
        } else {
            this.resetProgress();
        }
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
        this.setChanged();
    }

    public boolean hasCraftedResult() {
        return !this.craftResult.get("id").isEmpty();
    }

    public Map<String, String> getCraftResult() {
        return this.craftResult;
    }

    public void setCraftResult(Map<String, String> result) {
        this.craftResult = result;
        this.setChanged();
    }

    private boolean isSameRecipe(RecipeHolder<CauldronBrewingRecipe> recipe1, RecipeHolder<CauldronBrewingRecipe> recipe2) {
        if (recipe1 == null || recipe2 == null) {
            return false;
        }
        if (recipe1.id().equals((Object)recipe2.id())) {
            return true;
        }
        List<Ingredient> ingredients1 = ((CauldronBrewingRecipe)recipe1.value()).getInputItems();
        List<Ingredient> ingredients2 = ((CauldronBrewingRecipe)recipe2.value()).getInputItems();
        if (ingredients1.size() != ingredients2.size()) {
            return false;
        }
        ArrayList<Ingredient> sorted1 = new ArrayList<Ingredient>(ingredients1);
        ArrayList<Ingredient> sorted2 = new ArrayList<Ingredient>(ingredients2);
        sorted1.sort((a, b) -> a.toString().compareTo(b.toString()));
        sorted2.sort((a, b) -> a.toString().compareTo(b.toString()));
        for (int i = 0; i < sorted1.size(); ++i) {
            if (((Ingredient)sorted1.get(i)).toString().equals(((Ingredient)sorted2.get(i)).toString())) continue;
            return false;
        }
        return true;
    }

    private boolean hasRecipe() {
        boolean hasCorrectLadle;
        String recipeResultId;
        Optional<RecipeHolder<CauldronBrewingRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        RecipeHolder<CauldronBrewingRecipe> newRecipe = recipe.get();
        if (this.recipe != null && !this.isSameRecipe(this.recipe, newRecipe)) {
            this.resetProgress();
            return false;
        }
        ItemStack resultSlot = (ItemStack)this.items.get(5);
        if (!resultSlot.isEmpty() && !(recipeResultId = ((CauldronBrewingRecipe)newRecipe.value()).getOutput().get("id")).isEmpty()) {
            int recipeCount;
            ResourceLocation recipeItemId = ResourceLocation.parse((String)recipeResultId);
            ResourceLocation currentItemId = BuiltInRegistries.ITEM.getKey((Object)resultSlot.getItem());
            if (!currentItemId.equals((Object)recipeItemId)) {
                return false;
            }
            int currentCount = resultSlot.getCount();
            if (currentCount + (recipeCount = Integer.parseInt(((CauldronBrewingRecipe)newRecipe.value()).getOutput().get("count"))) > resultSlot.getMaxStackSize()) {
                return false;
            }
        }
        String interactionType = ((CauldronBrewingRecipe)newRecipe.value()).getOutput().get("interactionType");
        ItemStack ladleItem = (ItemStack)this.items.get(4);
        if (interactionType.equals("hand")) {
            this.recipe = newRecipe;
            this.maxProgress = ((CauldronBrewingRecipe)newRecipe.value()).getCookingTime();
            return true;
        }
        switch (interactionType) {
            case "bottle": {
                boolean bl;
                if (!ladleItem.isEmpty() && ladleItem.getItem() == Items.GLASS_BOTTLE) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "stick": {
                boolean bl;
                if (!ladleItem.isEmpty() && ladleItem.getItem() == Items.STICK) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "bucket": {
                boolean bl;
                if (!ladleItem.isEmpty() && ladleItem.getItem() == Items.BUCKET) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case "bowl": {
                boolean bl;
                if (!ladleItem.isEmpty() && ladleItem.getItem() == Items.BOWL) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = hasCorrectLadle = false;
            }
        }
        if (hasCorrectLadle) {
            this.recipe = newRecipe;
            this.maxProgress = ((CauldronBrewingRecipe)newRecipe.value()).getCookingTime();
            return true;
        }
        return false;
    }

    private Optional<RecipeHolder<CauldronBrewingRecipe>> getCurrentRecipe() {
        if (this.isCooking) {
            return Optional.empty();
        }
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ConcoctionModRecipes.CAULDRON_BREWING_RECIPE_TYPE.get(), (RecipeInput)new CauldronBrewingRecipeInput(this.getBlockState(), this.getItems()), this.level);
    }

    public int getContainerSize() {
        return this.ContainerSize;
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setItem(int slot, ItemStack stack) {
        boolean isLadleSlot;
        ItemStack previousStack = (ItemStack)this.items.get(slot);
        boolean isSlotEmpty = previousStack.isEmpty();
        boolean isStackEmpty = stack.isEmpty();
        boolean isDifferentItem = !isSlotEmpty && !isStackEmpty && !ItemStack.matches((ItemStack)previousStack, (ItemStack)stack);
        boolean isIngredientSlot = slot >= 0 && slot < 4;
        boolean bl = isLadleSlot = slot == 4;
        if ((isIngredientSlot || isLadleSlot) && (isDifferentItem || isSlotEmpty != isStackEmpty)) {
            ItemStack oldStack = (ItemStack)this.items.get(slot);
            ItemStack testStack = oldStack.copy();
            if (!testStack.isEmpty()) {
                testStack.setCount(1);
            }
            this.items.set(slot, (Object)testStack);
            Optional<RecipeHolder<CauldronBrewingRecipe>> originalRecipe = this.getCurrentRecipe();
            this.items.set(slot, (Object)stack);
            Optional<RecipeHolder<CauldronBrewingRecipe>> newRecipe = this.getCurrentRecipe();
            boolean shouldReset = false;
            if (this.isCooking && this.recipe != null) {
                if (originalRecipe.isPresent() && this.isSameRecipe(originalRecipe.get(), this.recipe)) {
                    shouldReset = false;
                } else if (newRecipe.isPresent()) {
                    if (!this.isSameRecipe(newRecipe.get(), this.recipe)) {
                        shouldReset = true;
                    }
                } else {
                    shouldReset = true;
                }
            }
            this.items.set(slot, (Object)oldStack);
            if (shouldReset) {
                BlockState state;
                this.resetProgressOnly();
                if (this.level != null && (state = this.level.getBlockState(this.worldPosition)).hasProperty((Property)CookingCauldron.COOKING)) {
                    this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)CookingCauldron.COOKING, (Comparable)Boolean.valueOf(false)), 3);
                }
            }
        }
        stack.limitSize(this.getMaxStackSize(stack));
        this.items.set(slot, (Object)stack);
        this.setChanged();
    }

    protected void setItems(NonNullList<ItemStack> Items2) {
        this.items = Items2;
        this.setChanged();
    }

    public boolean addItemOnClick(ItemStack addedItem, int count, boolean isCreative) {
        boolean flag = false;
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemstack = this.getItem(i);
            if (!itemstack.isEmpty()) continue;
            this.setItem(i, isCreative ? addedItem.copyWithCount(1) : addedItem.split(count));
            flag = true;
            break;
        }
        if (flag) {
            this.resetProgress();
        }
        return flag;
    }

    public ItemStack takeItemOnClick(boolean takeAll) {
        ItemStack returnStack = ItemStack.EMPTY;
        for (int i = this.items.size() - 1; i >= 0; --i) {
            ItemStack itemstack = (ItemStack)this.items.get(i);
            if (itemstack.isEmpty()) continue;
            if (takeAll) {
                returnStack = itemstack.copy();
                this.setItem(i, ItemStack.EMPTY);
            } else {
                returnStack = itemstack.split(1);
            }
            this.setChanged();
            this.resetProgress();
            return returnStack;
        }
        return returnStack;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        tag.putInt("Progress", this.progress);
        tag.putInt("MaxProgress", this.maxProgress);
        tag.putBoolean("IsCooking", this.isCooking);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        CompoundTag tag = packet.getTag();
        this.handleUpdateTag(tag, registries);
        this.progress = tag.getInt("Progress");
        this.maxProgress = tag.getInt("MaxProgress");
        this.isCooking = tag.getBoolean("IsCooking");
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.handleUpdateTag(tag, registries);
        this.loadAdditional(tag, registries);
        this.progress = tag.getInt("Progress");
        this.maxProgress = tag.getInt("MaxProgress");
        this.isCooking = tag.getBoolean("IsCooking");
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.cooking_cauldron");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new BoilingCauldronInterfaceMenu(pContainerId, pPlayerInventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    protected AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory) {
        return this.createMenu(pContainerId, pPlayerInventory, null);
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public boolean isCooking() {
        return this.isCooking;
    }

    public boolean isLit() {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)CookingCauldron.LIT)) {
            return (Boolean)state.getValue((Property)CookingCauldron.LIT);
        }
        return false;
    }
}

