/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.compat;

import java.util.Arrays;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.mcreator.concoction.init.ConcoctionModItems;
import net.mcreator.concoction.recipe.butterChurn.ButterChurnRecipe;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ButterChurnRecipeCategory
implements IRecipeCategory<ButterChurnRecipe> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"textures/gui/butter_churn_gui_jei.png");
    public static final RecipeType<ButterChurnRecipe> BUTTER_CHURN_RECIPE_TYPE = RecipeType.create((String)"concoction", (String)"butter_churn", ButterChurnRecipe.class);
    @Nonnull
    private final IDrawable background;
    private final IDrawable icon;

    public ButterChurnRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 134, 58);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ConcoctionModItems.BUTTER_CHURN.get()));
    }

    public RecipeType<ButterChurnRecipe> getRecipeType() {
        return BUTTER_CHURN_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"gui.butter_churn.title");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public static boolean isCursorInsideBounds(int iconX, int iconY, int iconWidth, int iconHeight, double cursorX, double cursorY) {
        return (double)iconX <= cursorX && cursorX < (double)(iconX + iconWidth) && (double)iconY <= cursorY && cursorY < (double)(iconY + iconHeight);
    }

    public void getTooltip(ITooltipBuilder tooltip, ButterChurnRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (ButterChurnRecipeCategory.isCursorInsideBounds(44, 20, 44, 23, mouseX, mouseY)) {
            tooltip.add((FormattedText)Component.translatable((String)"gui.butter_churn.chance"));
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ButterChurnRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 16, 20).addItemStack(new ItemStack((ItemLike)recipe.getIngredient(0).getItems()[0].getItem(), recipe.getInputItems().size()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 84, 20).addItemStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)recipe.getOutput().get("id"))), Integer.parseInt(recipe.getOutput().get("count"))));
        TagKey SHOVELS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"shovels"));
        builder.addSlot(RecipeIngredientRole.CATALYST, 48, 2).addItemStacks(Arrays.asList(Ingredient.of((TagKey)SHOVELS).getItems()));
        ItemStack catalyst = switch (recipe.getOutput().get("interactionType")) {
            case "hand" -> ItemStack.EMPTY;
            case "bottle" -> new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            default -> ItemStack.EMPTY;
        };
        builder.addSlot(RecipeIngredientRole.CATALYST, 109, 20).addItemStack(catalyst);
    }
}

