/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.compat;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.mcreator.concoction.init.ConcoctionModBlocks;
import net.mcreator.concoction.recipe.oven.OvenRecipe;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class OvenRecipeCategory
implements IRecipeCategory<OvenRecipe> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"textures/gui/oven_gui_jei.png");
    public static final RecipeType<OvenRecipe> OVEN_RECIPE_TYPE = RecipeType.create((String)"concoction", (String)"oven", OvenRecipe.class);
    @Nonnull
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;
    protected final IDrawableAnimated arrow;

    public OvenRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 170, 76);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(ConcoctionModBlocks.OVEN));
        this.arrow = helper.drawableBuilder(TEXTURE, 171, 14, 23, 16).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.slot = helper.drawableBuilder(TEXTURE, 171, 31, 18, 18).build();
    }

    public RecipeType<OvenRecipe> getRecipeType() {
        return OVEN_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"gui.oven.title");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(OvenRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 100, 30);
    }

    public static boolean isCursorInsideBounds(int iconX, int iconY, int iconWidth, int iconHeight, double cursorX, double cursorY) {
        return (double)iconX <= cursorX && cursorX < (double)(iconX + iconWidth) && (double)iconY <= cursorY && cursorY < (double)(iconY + iconHeight);
    }

    public void getTooltip(ITooltipBuilder tooltip, OvenRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        int cookTimeSeconds;
        if (OvenRecipeCategory.isCursorInsideBounds(100, 31, 24, 16, mouseX, mouseY) && (cookTimeSeconds = recipe.getCookingTime() / 20) > 0) {
            tooltip.add((FormattedText)Component.translatable((String)"gui.cooking_cauldron.time.seconds", (Object[])new Object[]{cookTimeSeconds}));
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, OvenRecipe recipe, IFocusGroup focuses) {
        List<Ingredient> list = recipe.getCraftingIngredients();
        int baseX = 38;
        int baseY = 20;
        for (int i = 0; i < list.size(); ++i) {
            builder.addSlot(RecipeIngredientRole.INPUT, baseX, baseY).addIngredients(list.get(i));
            if (baseX < 74) {
                baseX += 18;
                continue;
            }
            baseY += 18;
            baseX = 38;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 136, 30).addItemStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)recipe.getResult().get("id"))), Integer.parseInt(recipe.getResult().get("count"))));
        if (!recipe.getBowlIngredient().hasNoItems()) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 101, 9).addIngredients(recipe.getBowlIngredient());
        }
        if (!recipe.getBottleIngredient().hasNoItems()) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 16, 29).setBackground(this.slot, 0, 0).addIngredients(recipe.getBottleIngredient());
        }
    }
}

