/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.entity;

import java.util.EnumSet;
import java.util.List;
import net.mcreator.concoction.init.ConcoctionModBlocks;
import net.mcreator.concoction.init.ConcoctionModEntities;
import net.mcreator.concoction.init.ConcoctionModParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

public class CordycepsCaveSpiderEntity
extends CaveSpider {
    public CordycepsCaveSpiderEntity(EntityType<? extends CaveSpider> type, Level world) {
        super(type, world);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.removeAllGoals(goal -> goal instanceof NearestAttackableTargetGoal);
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.goalSelector.addGoal(5, (Goal)new MoveToSkyGoal(this));
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)ConcoctionModEntities.CORDYCEPS_CAVE_SPIDER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    private void applyPoisonBasedOnDifficulty(LivingEntity target) {
        Difficulty diff = this.level().getDifficulty();
        int durationTicks = 0;
        if (diff == Difficulty.NORMAL) {
            durationTicks = 140;
        } else if (diff == Difficulty.HARD) {
            durationTicks = 300;
        }
        if (durationTicks > 0) {
            target.addEffect(new MobEffectInstance(MobEffects.POISON, durationTicks, 0));
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        Level level;
        boolean result = super.hurt(source, amount);
        if (!this.level().isClientSide && result && this.isAlive() && this.getRandom().nextFloat() < 0.5f && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            this.triggerSpores(serverWorld, this.blockPosition(), 3.0, 40);
            this.spreadSporesBlocks(serverWorld, this.blockPosition(), 3, 12);
        }
        return result;
    }

    public void die(DamageSource cause) {
        Level level;
        super.die(cause);
        if (!this.level().isClientSide && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            this.triggerSpores(serverWorld, this.blockPosition(), 6.0, 80);
            this.spreadSporesBlocks(serverWorld, this.blockPosition(), 6, 25);
            this.poisonNearbyOnDeath(serverWorld, this.blockPosition(), 6.0);
        }
    }

    private void poisonNearbyOnDeath(ServerLevel serverWorld, BlockPos center, double radius) {
        List nearby = serverWorld.getEntitiesOfClass(LivingEntity.class, new AABB(center).inflate(radius), e -> e != this);
        for (LivingEntity target : nearby) {
            this.applyPoisonBasedOnDifficulty(target);
        }
    }

    private void triggerSpores(ServerLevel serverWorld, BlockPos center, double radius, int duration) {
        serverWorld.sendParticles((ParticleOptions)((SimpleParticleType)ConcoctionModParticleTypes.SPORE_CLOUD.get()), (double)center.getX() + 0.5, (double)center.getY() + 0.5, (double)center.getZ() + 0.5, 20, 0.5, 0.5, 0.5, 0.01);
        List nearby = serverWorld.getEntitiesOfClass(LivingEntity.class, new AABB(center).inflate(radius), e -> e != this);
        for (LivingEntity target : nearby) {
            target.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, duration, 0));
        }
    }

    private void spreadSporesBlocks(ServerLevel serverWorld, BlockPos center, int radius, int attempts) {
        RandomSource random = serverWorld.getRandom();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < attempts; ++i) {
            BlockState sporeState;
            int dx = random.nextInt(radius * 2 + 1) - radius;
            int dy = random.nextInt(3) - 1;
            int dz = random.nextInt(radius * 2 + 1) - radius;
            mutablePos.set(center.getX() + dx, center.getY() + dy, center.getZ() + dz);
            BlockState targetState = serverWorld.getBlockState((BlockPos)mutablePos);
            if (!targetState.isAir() || !(sporeState = ((Block)ConcoctionModBlocks.CROP_PUFFBALL.get()).defaultBlockState()).canSurvive((LevelReader)serverWorld, (BlockPos)mutablePos)) continue;
            serverWorld.setBlock((BlockPos)mutablePos, sporeState, 3);
            serverWorld.sendParticles((ParticleOptions)((SimpleParticleType)ConcoctionModParticleTypes.SPORE_CLOUD.get()), (double)mutablePos.getX() + 0.5, (double)mutablePos.getY() + 1.0, (double)mutablePos.getZ() + 0.5, 5, 0.3, 0.3, 0.3, 0.01);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = CaveSpider.createAttributes();
        builder = builder.add(Attributes.MAX_HEALTH, 16.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 1.0);
        return builder;
    }

    static class MoveToSkyGoal
    extends Goal {
        private final CordycepsCaveSpiderEntity spider;
        private BlockPos targetPos;

        public MoveToSkyGoal(CordycepsCaveSpiderEntity spider) {
            this.spider = spider;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            Level level = this.spider.level();
            for (int i = 0; i < 10; ++i) {
                BlockPos randomPos = this.spider.blockPosition().offset(this.spider.getRandom().nextInt(16) - 8, this.spider.getRandom().nextInt(6) - 3, this.spider.getRandom().nextInt(16) - 8);
                if (!level.canSeeSky(randomPos.above())) continue;
                this.targetPos = randomPos;
                return true;
            }
            return false;
        }

        public void start() {
            if (this.targetPos != null) {
                this.spider.getNavigation().moveTo((double)this.targetPos.getX(), (double)this.targetPos.getY(), (double)this.targetPos.getZ(), 1.0);
            }
        }
    }
}

