/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.fluid;

import net.mcreator.concoction.init.ConcoctionModBlocks;
import net.mcreator.concoction.init.ConcoctionModFluidTypes;
import net.mcreator.concoction.init.ConcoctionModFluids;
import net.mcreator.concoction.init.ConcoctionModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class WeightedSoulsFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)ConcoctionModFluidTypes.WEIGHTED_SOULS_TYPE.get(), () -> (Fluid)ConcoctionModFluids.WEIGHTED_SOULS.get(), () -> (Fluid)ConcoctionModFluids.FLOWING_WEIGHTED_SOULS.get()).explosionResistance(100.0f).tickRate(20).levelDecreasePerBlock(2).bucket(() -> (Item)ConcoctionModItems.WEIGHTED_SOULS_BUCKET.get()).block(() -> (LiquidBlock)ConcoctionModBlocks.WEIGHTED_SOULS.get());

    private WeightedSoulsFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.SOUL;
    }

    public void spread(Level level, BlockPos pos, FluidState fluidState) {
        if (!fluidState.isEmpty()) {
            BlockState blockstate = level.getBlockState(pos);
            BlockPos blockposDown = pos.below();
            BlockState blockstateDown = level.getBlockState(blockposDown);
            boolean lavaOnLevelOrHigher = false;
            for (Direction direction : Direction.values()) {
                BlockPos neighborPos = pos.relative(direction);
                FluidState neighborFluidState = level.getFluidState(neighborPos);
                if (!neighborFluidState.getType().defaultFluidState().is((Fluid)Fluids.LAVA) && !neighborFluidState.getType().defaultFluidState().is((Fluid)Fluids.FLOWING_LAVA) || neighborPos.getY() < pos.getY()) continue;
                lavaOnLevelOrHigher = true;
                break;
            }
            if (lavaOnLevelOrHigher) {
                level.setBlockAndUpdate(pos, Blocks.BLACKSTONE.defaultBlockState());
                level.playSound(null, pos, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 0.7f, 1.0f);
            } else if (level.getFluidState(blockposDown).getType().defaultFluidState().is((Fluid)Fluids.LAVA) || level.getFluidState(blockposDown).getType().defaultFluidState().is((Fluid)Fluids.FLOWING_LAVA)) {
                level.setBlockAndUpdate(blockposDown, Blocks.BLACKSTONE.defaultBlockState());
                level.playSound(null, blockposDown, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 0.7f, 1.0f);
            }
            super.spread(level, pos, fluidState);
        } else {
            super.spread(level, pos, fluidState);
        }
    }

    public static class Flowing
    extends WeightedSoulsFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends WeightedSoulsFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

