/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.item;

import net.mcreator.concoction.utils.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class OvergrownAxeItem
extends AxeItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 131;
        }

        public float getSpeed() {
            return 6.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_DIAMOND_TOOL;
        }

        public int getEnchantmentValue() {
            return 15;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of();
        }
    };

    public OvergrownAxeItem() {
        super(TOOL_TIER, new Item.Properties().attributes(DiggerItem.createAttributes((Tier)TOOL_TIER, (float)6.0f, (float)-3.2f)));
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        System.out.println(itemstack.getDamageValue() + " / AXE HIT / " + itemstack.getMaxDamage());
        if (itemstack.getMaxDamage() - itemstack.getDamageValue() <= 1) {
            return false;
        }
        if (itemstack.getMaxDamage() - itemstack.getDamageValue() <= 2) {
            System.out.println(itemstack.getDamageValue() + " / AXE ! HIT / " + itemstack.getMaxDamage());
            itemstack.setDamageValue(itemstack.getMaxDamage() - 1);
            return false;
        }
        return super.hurtEnemy(itemstack, entity, sourceentity);
    }

    public boolean mineBlock(ItemStack itemstack, Level world, BlockState blockstate, BlockPos pos, LivingEntity entity) {
        System.out.println(itemstack.getDamageValue() + " / AXE BLOCK / " + itemstack.getMaxDamage());
        if (itemstack.getMaxDamage() - itemstack.getDamageValue() <= 1) {
            return false;
        }
        if (itemstack.getMaxDamage() - itemstack.getDamageValue() <= 2) {
            System.out.println(itemstack.getDamageValue() + " / AXE ! BLOCK / " + itemstack.getMaxDamage());
            itemstack.setDamageValue(itemstack.getMaxDamage() - 1);
            return false;
        }
        return super.mineBlock(itemstack, world, blockstate, pos, entity);
    }

    public int getBarColor(ItemStack stack) {
        return Utils.getColor(stack);
    }
}

