/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.mixins;

import net.mcreator.concoction.init.ConcoctionModMobEffects;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.EnchantmentMenu;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentMenu.class})
public class EnchantmentMenuMixin {
    @Unique
    private int concoction$cachedId = -1;
    @Unique
    private int concoction$cachedXpBefore = 0;

    @Inject(method={"clickMenuButton"}, at={@At(value="HEAD")})
    private void concoction$cacheXp(Player player, int id, CallbackInfoReturnable<Boolean> cir) {
        this.concoction$cachedId = id;
        this.concoction$cachedXpBefore = EnchantmentMenuMixin.getTotalXp(player);
    }

    @Inject(method={"clickMenuButton"}, at={@At(value="RETURN")})
    private void concoction$onEnchant(Player player, int id, CallbackInfoReturnable<Boolean> cir) {
        MobEffectInstance bitterness;
        int amplifier;
        double multiplier;
        int cashback;
        int xpAfter;
        int xpSpent;
        Boolean result = (Boolean)cir.getReturnValue();
        if (result != null && result.booleanValue() && this.concoction$cachedId >= 0 && this.concoction$cachedId <= 2 && (xpSpent = this.concoction$cachedXpBefore - (xpAfter = EnchantmentMenuMixin.getTotalXp(player))) > 0 && player.hasEffect(ConcoctionModMobEffects.BITTERNESS) && (cashback = (int)((double)xpSpent * (multiplier = 0.2 + 0.1 * (double)(amplifier = (bitterness = player.getEffect(ConcoctionModMobEffects.BITTERNESS)).getAmplifier())))) > 0) {
            player.giveExperiencePoints(cashback);
        }
        this.concoction$cachedId = -1;
        this.concoction$cachedXpBefore = 0;
    }

    @Unique
    private static int getTotalXp(Player player) {
        int level = player.experienceLevel;
        float progress = player.experienceProgress;
        int xpForLevel = EnchantmentMenuMixin.getXpNeededForLevel(level);
        return EnchantmentMenuMixin.getTotalXpAtLevel(level) + Math.round(progress * (float)xpForLevel);
    }

    @Unique
    private static int getXpNeededForLevel(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    @Unique
    private static int getTotalXpAtLevel(int level) {
        if (level >= 30) {
            return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
        }
        if (level >= 15) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return level * level + 6 * level;
    }
}

