/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.mixins;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin {
    @Unique
    private int concoction$tickCounter = 0;

    @Shadow
    public abstract ItemStack getItem();

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        BlockEntity blockEntity;
        ItemEntity itemEntity = (ItemEntity)this;
        if (!itemEntity.getItem().is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:tableware")))) {
            return;
        }
        BlockPos itemPos = itemEntity.blockPosition();
        Optional nearestChest = BlockPos.findClosestMatch((BlockPos)itemPos, (int)10, (int)10, blockPos -> itemEntity.level().getBlockState(blockPos).is(BlockTags.create((ResourceLocation)ResourceLocation.parse((String)"concoction:kitchen_cabinets"))));
        if (nearestChest.isPresent() && (blockEntity = itemEntity.level().getBlockEntity((BlockPos)nearestChest.get())) instanceof Container) {
            Container container = (Container)blockEntity;
            ++this.concoction$tickCounter;
            for (int i = 0; i < container.getContainerSize(); ++i) {
                if (!container.canPlaceItem(i, itemEntity.getItem()) || this.concoction$tickCounter <= 200) continue;
                this.concoction$tickCounter = 0;
                if (!container.isEmpty()) {
                    ItemStack stack = container.getItem(i);
                    stack.setCount(stack.getCount() + itemEntity.getItem().getCount());
                    container.setItem(i, stack);
                } else {
                    container.setItem(i, itemEntity.getItem().copy());
                }
                itemEntity.discard();
                break;
            }
        }
    }
}

