/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.mixins;

import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.EntityHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Snowball.class})
public abstract class SnowballMixin {
    @Inject(method={"onHitEntity"}, at={@At(value="HEAD")})
    private void concoction$freezeOnSnowballHit(EntityHitResult result, CallbackInfo ci) {
        Entity hitEntity;
        Snowball snowball = (Snowball)this;
        if (!snowball.level().isClientSide && (hitEntity = result.getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)hitEntity;
            if (living.getType().is(EntityTypeTags.POWDER_SNOW_WALKABLE_MOBS)) {
                return;
            }
            DamageSource source = snowball.damageSources().freeze();
            living.hurt(source, 1.0f);
            int leatherCount = 0;
            if (living.getItemBySlot(EquipmentSlot.HEAD).is(Items.LEATHER_HELMET)) {
                ++leatherCount;
            }
            if (living.getItemBySlot(EquipmentSlot.CHEST).is(Items.LEATHER_CHESTPLATE)) {
                ++leatherCount;
            }
            if (living.getItemBySlot(EquipmentSlot.LEGS).is(Items.LEATHER_LEGGINGS)) {
                ++leatherCount;
            }
            if (living.getItemBySlot(EquipmentSlot.FEET).is(Items.LEATHER_BOOTS)) {
                ++leatherCount;
            }
            float freezeChance = 1.0f - 0.25f * (float)leatherCount;
            if (Math.random() < (double)freezeChance) {
                int frozen = living.getTicksFrozen();
                if (frozen >= 200) {
                    living.setTicksFrozen(350);
                } else {
                    living.setTicksFrozen(frozen + 100);
                }
            }
        }
    }
}

