/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.potion;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.mcreator.concoction.init.ConcoctionModMobEffects;
import net.mcreator.concoction.utils.Utils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class SpicyMobEffect
extends MobEffect {
    private static int tickCounter = 0;
    private static final ResourceLocation SPICY_ATTACK_SPEED = ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"spicy_attack_speed");

    public SpicyMobEffect() {
        super(MobEffectCategory.NEUTRAL, -46336);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public void addAttributeModifiers(AttributeMap attributeMap, int amplifier) {
        AttributeInstance attackSpeedAttribute = attributeMap.getInstance(Attributes.ATTACK_SPEED);
        if (attackSpeedAttribute != null) {
            double increaseValue = (double)(amplifier + 1) * 0.15;
            AttributeModifier attackSpeedModifier = new AttributeModifier(SPICY_ATTACK_SPEED, increaseValue, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            attackSpeedAttribute.addTransientModifier(attackSpeedModifier);
        }
        super.addAttributeModifiers(attributeMap, amplifier);
    }

    public void removeAttributeModifiers(AttributeMap attributeMap) {
        AttributeInstance attackSpeedAttribute = attributeMap.getInstance(Attributes.ATTACK_SPEED);
        if (attackSpeedAttribute != null) {
            attackSpeedAttribute.removeModifier(SPICY_ATTACK_SPEED);
        }
        super.removeAttributeModifiers(attributeMap);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Level pLevel;
        LivingEntity livEnt;
        Level world = entity.level();
        if (entity instanceof LivingEntity && (livEnt = entity).hasEffect(ConcoctionModMobEffects.SPICY) && world instanceof Level && !(pLevel = world).isClientSide() && livEnt instanceof ServerPlayer) {
            List<Pair> list;
            ServerPlayer player = (ServerPlayer)livEnt;
            int tickInterval = 60 - amplifier * 10;
            if (tickInterval < 20) {
                tickInterval = 20;
            }
            if (tickCounter >= tickInterval && (double)player.getHealth() > 1.0) {
                livEnt.hurt(new DamageSource(world.holderOrThrow(ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)"concoction:spicy_damage")))), 1.0f);
                tickCounter = 0;
            }
            if ((list = livEnt.getActiveEffects().stream().map(effect -> new Pair((Object)effect.getEffect(), (Object)((MobEffect)effect.getEffect().value()).getCategory())).filter(pair -> ((MobEffectCategory)pair.getSecond()).equals((Object)MobEffectCategory.HARMFUL)).distinct().toList()).size() >= 5) {
                Utils.addAchievement(player, "concoction:spicy_remove_many_debuffs");
            }
            list.forEach(pair -> livEnt.removeEffect((Holder)pair.getFirst()));
            if (player.isOnFire()) {
                Utils.addAchievement(player, "concoction:spicy_on_fire");
            }
            ++tickCounter;
        }
        return super.applyEffectTick(entity, amplifier);
    }
}

