/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.potion;

import net.mcreator.concoction.ConcoctionMod;
import net.mcreator.concoction.init.ConcoctionModMobEffects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class SunstruckEffectMobEffect
extends MobEffect {
    public SunstruckEffectMobEffect() {
        super(MobEffectCategory.HARMFUL, -1458376);
    }

    public void removeAttributeModifiers(AttributeMap attrMap) {
        AttributeInstance maxHealth = attrMap.getInstance(Attributes.MAX_HEALTH);
        AttributeInstance speed_instance = attrMap.getInstance(Attributes.MOVEMENT_SPEED);
        AttributeInstance atk_speed_instance = attrMap.getInstance(Attributes.ATTACK_SPEED);
        if (maxHealth != null) {
            maxHealth.removeModifier(ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"sunstruck_max_health_reduction"));
        }
        if (speed_instance != null) {
            speed_instance.removeModifier(ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"sunstruck_speed"));
        }
        if (atk_speed_instance != null) {
            atk_speed_instance.removeModifier(ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"sunstruck_atk_speed"));
        }
        super.removeAttributeModifiers(attrMap);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Level pLevel;
        Level level;
        LivingEntity livEnt;
        if (entity instanceof LivingEntity && (livEnt = entity).hasEffect(ConcoctionModMobEffects.SUNSTRUCK_EFFECT) && (level = entity.level()) instanceof Level && !(pLevel = level).isClientSide()) {
            AttributeMap attributes = livEnt.getAttributes();
            ResourceLocation mhr = ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"sunstruck_max_health_reduction");
            AttributeModifier mhr_modifier = new AttributeModifier(mhr, Math.max(-16.0, (double)(amplifier + 1) * -4.0), AttributeModifier.Operation.ADD_VALUE);
            AttributeInstance instance = attributes.getInstance(Attributes.MAX_HEALTH);
            if (instance != null && !instance.hasModifier(mhr)) {
                instance.addTransientModifier(mhr_modifier);
            }
            ResourceLocation speed = ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"sunstruck_speed");
            AttributeModifier speed_modifier = new AttributeModifier(speed, (double)((amplifier + 1) * 0), AttributeModifier.Operation.ADD_VALUE);
            ResourceLocation atk_speed = ResourceLocation.fromNamespaceAndPath((String)"concoction", (String)"sunstruck_atk_speed");
            AttributeModifier atk_speed_modifier = new AttributeModifier(atk_speed, (double)(amplifier + 1) * 0.2, AttributeModifier.Operation.ADD_VALUE);
            AttributeInstance speed_instance = attributes.getInstance(Attributes.MOVEMENT_SPEED);
            AttributeInstance atk_speed_instance = attributes.getInstance(Attributes.ATTACK_SPEED);
            if (speed_instance == null || atk_speed_instance == null) {
                ConcoctionMod.LOGGER.warn("SunstruckEffectMobEffect: Unable to find speed or attack speed attribute instance for entity: " + String.valueOf(entity));
                return super.applyEffectTick(entity, amplifier);
            }
            int dayTime = Math.floorMod(pLevel.dayTime(), 24000);
            if (pLevel.dimension() == Level.OVERWORLD && (dayTime >= 0 && dayTime < 13000 || dayTime >= 23000 && dayTime < 24000)) {
                if (!speed_instance.hasModifier(speed)) {
                    speed_instance.addTransientModifier(speed_modifier);
                }
                if (!atk_speed_instance.hasModifier(atk_speed)) {
                    atk_speed_instance.addTransientModifier(atk_speed_modifier);
                }
            } else {
                speed_instance.removeModifier(speed_modifier);
                atk_speed_instance.removeModifier(atk_speed_modifier);
            }
        }
        return super.applyEffectTick(entity, amplifier);
    }
}

