/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.recipe.butterChurn;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mcreator.concoction.ConcoctionMod;
import net.mcreator.concoction.block.ButterChurnBlock;
import net.mcreator.concoction.init.ConcoctionModItems;
import net.mcreator.concoction.init.ConcoctionModRecipes;
import net.mcreator.concoction.recipe.butterChurn.ButterChurnRecipeInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ButterChurnRecipe
implements Recipe<ButterChurnRecipeInput> {
    private final BlockState inputState;
    private final List<Ingredient> inputItems;
    private final Map<String, String> result;

    public BlockState getInputState() {
        return this.inputState;
    }

    public List<Ingredient> getInputItems() {
        return this.inputItems;
    }

    public Ingredient getIngredient(int index) {
        if (index < 0 || index >= this.inputItems.size()) {
            return Ingredient.EMPTY;
        }
        return this.inputItems.get(index);
    }

    public Map<String, String> getResult() {
        return this.result;
    }

    public ButterChurnRecipe(BlockState inputState, List<Ingredient> inputItems, Map<String, String> result) {
        this.inputState = inputState;
        this.inputItems = inputItems;
        this.result = result;
    }

    public boolean matches(ButterChurnRecipeInput pInput, Level pLevel) {
        if (pLevel.isClientSide()) {
            return false;
        }
        boolean stateMatches = ((Boolean)this.inputState.getValue((Property)ButterChurnBlock.FULL)).equals(pInput.state().getValue((Property)ButterChurnBlock.FULL));
        boolean itemMatches = this.inputItems.getFirst().getItems()[0].getItem().equals(pInput.getItem(0).getItem());
        boolean countMatches = this.inputItems.size() == pInput.count();
        ConcoctionMod.LOGGER.info(String.format("Matching recipe for %s with count %d. State: %b, Item: %b, Count: %b", pInput.getItem(0), pInput.count(), stateMatches, itemMatches, countMatches));
        if (stateMatches) {
            return itemMatches && countMatches;
        }
        return false;
    }

    public ItemStack assemble(ButterChurnRecipeInput pInput, HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider p_336125_) {
        return null;
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ConcoctionModItems.BUTTER_CHURN.get());
    }

    public Map<String, String> getOutput() {
        return this.result;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ConcoctionModRecipes.BUTTER_CHURN_RECIPE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ConcoctionModRecipes.BUTTER_CHURN_RECIPE_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<ButterChurnRecipe> {
        public static final MapCodec<ButterChurnRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)BlockState.CODEC.fieldOf("state").forGetter(ButterChurnRecipe::getInputState), (App)Ingredient.LIST_CODEC_NONEMPTY.fieldOf("ingredients").forGetter(ButterChurnRecipe::getInputItems), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).fieldOf("result").forGetter(ButterChurnRecipe::getResult)).apply((Applicative)inst, ButterChurnRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ButterChurnRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY), ButterChurnRecipe::getInputState, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), ButterChurnRecipe::getInputItems, (StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ByteBufCodecs.STRING_UTF8, (StreamCodec)ByteBufCodecs.STRING_UTF8), ButterChurnRecipe::getResult, ButterChurnRecipe::new);

        public MapCodec<ButterChurnRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ButterChurnRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

