/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.utils;

import com.mojang.blaze3d.vertex.VertexConsumer;

public class ColoredVertexConsumer
implements VertexConsumer {
    private final VertexConsumer parent;
    private final float r;
    private final float g;
    private final float b;

    public ColoredVertexConsumer(VertexConsumer parent, float r, float g, float b) {
        this.parent = parent;
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public VertexConsumer addVertex(float x, float y, float z) {
        this.parent.addVertex(x, y, z);
        return this;
    }

    public VertexConsumer setColor(int r, int g, int b, int a) {
        int newR = (int)((float)r * this.r);
        int newG = (int)((float)g * this.g);
        int newB = (int)((float)b * this.b);
        newR = Math.min(255, Math.max(0, newR));
        newG = Math.min(255, Math.max(0, newG));
        newB = Math.min(255, Math.max(0, newB));
        return this.parent.setColor(newR, newG, newB, a);
    }

    public VertexConsumer setUv(float u, float v) {
        this.parent.setUv(u, v);
        return this;
    }

    public VertexConsumer setUv1(int u, int v) {
        this.parent.setUv1(u, v);
        return this;
    }

    public VertexConsumer setUv2(int u, int v) {
        this.parent.setUv2(u, v);
        return this;
    }

    public VertexConsumer setNormal(float x, float y, float z) {
        this.parent.setNormal(x, y, z);
        return this;
    }
}

