/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.utils;

import net.mcreator.concoction.block.RiceBlockBlock;
import net.mcreator.concoction.init.ConcoctionModBlocks;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class Utils {
    private static final Direction[] ALL_DIRECTIONS = Direction.values();

    public static void addAchievement(ServerPlayer player, String achievement) {
        AdvancementProgress _ap;
        AdvancementHolder adv = player.server.getAdvancements().get(ResourceLocation.parse((String)achievement));
        if (adv != null && !(_ap = player.getAdvancements().getOrStartProgress(adv)).isDone()) {
            for (String criteria : _ap.getRemainingCriteria()) {
                player.getAdvancements().award(adv, criteria);
            }
        }
    }

    public static int getColor(ItemStack stack) {
        float durabilityPercent = 1.0f - (float)stack.getDamageValue() / (float)stack.getMaxDamage();
        if (durabilityPercent < 0.2f) {
            return 6180487;
        }
        if (durabilityPercent < 0.36f) {
            return 8681369;
        }
        if (durabilityPercent < 0.52f) {
            return 11971759;
        }
        if (durabilityPercent < 0.68f) {
            return 13681841;
        }
        if (durabilityPercent < 0.84f) {
            return 14403742;
        }
        return 16763724;
    }

    public static boolean touchesLiquid(BlockGetter level, BlockPos blockPos, BlockState state) {
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = blockPos.mutable();
        for (Direction direction : Direction.values()) {
            BlockState blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (direction == Direction.DOWN && !state.canBeHydrated(level, blockPos, blockstate.getFluidState(), (BlockPos)blockpos$mutableblockpos)) continue;
            blockpos$mutableblockpos.setWithOffset((Vec3i)blockPos, direction);
            blockstate = level.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (!state.canBeHydrated(level, blockPos, blockstate.getFluidState(), (BlockPos)blockpos$mutableblockpos) || blockstate.isFaceSturdy(level, blockPos, direction.getOpposite())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean shouldSolidify(BlockGetter level, BlockPos blockPos, BlockState blockState, FluidState fluidState) {
        return blockState.canBeHydrated(level, blockPos, fluidState, blockPos) || Utils.touchesLiquid(level, blockPos, blockState);
    }

    public static void tryAbsorbWater(Level level, BlockPos blockPos, RiceBlockBlock block) {
        if (Utils.removeWaterBreadthFirstSearch(level, blockPos, block)) {
            level.setBlock(blockPos, ((Block)ConcoctionModBlocks.SOAKED_RICE_BLOCK.get()).defaultBlockState(), 2);
            level.playSound((Player)null, blockPos, SoundEvents.SPONGE_ABSORB, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static boolean removeWaterBreadthFirstSearch(Level level, BlockPos blockPos, RiceBlockBlock block) {
        BlockState spongeState = level.getBlockState(blockPos);
        return BlockPos.breadthFirstTraversal((BlockPos)blockPos, (int)5, (int)20, (p_277519_, p_277492_) -> {
            for (Direction direction : ALL_DIRECTIONS) {
                p_277492_.accept(p_277519_.relative(direction));
            }
        }, p_294069_ -> {
            BucketPickup bucketpickup;
            if (p_294069_.equals((Object)blockPos)) {
                return true;
            }
            BlockState blockstate = level.getBlockState(p_294069_);
            FluidState fluidstate = level.getFluidState(p_294069_);
            if (!spongeState.canBeHydrated((BlockGetter)level, blockPos, fluidstate, p_294069_)) {
                return false;
            }
            Block patt0$temp = blockstate.getBlock();
            if (patt0$temp instanceof BucketPickup && !(bucketpickup = (BucketPickup)patt0$temp).pickupBlock((Player)null, (LevelAccessor)level, p_294069_, blockstate).isEmpty()) {
                return true;
            }
            if (blockstate.getBlock() instanceof LiquidBlock) {
                level.setBlock(p_294069_, Blocks.AIR.defaultBlockState(), 5);
            } else {
                if (!(blockstate.is(Blocks.KELP) || blockstate.is(Blocks.KELP_PLANT) || blockstate.is(Blocks.SEAGRASS) || blockstate.is(Blocks.TALL_SEAGRASS))) {
                    return false;
                }
                BlockEntity blockentity = blockstate.hasBlockEntity() ? level.getBlockEntity(p_294069_) : null;
                RiceBlockBlock.dropResources((BlockState)blockstate, (LevelAccessor)level, (BlockPos)p_294069_, (BlockEntity)blockentity);
                level.setBlock(p_294069_, Blocks.AIR.defaultBlockState(), 3);
            }
            return true;
        }) > 1;
    }
}

