/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.world.inventory;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mcreator.concoction.block.entity.CookingCauldronEntity;
import net.mcreator.concoction.init.ConcoctionModMenus;
import net.mcreator.concoction.utils.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class BoilingCauldronInterfaceMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private ContainerLevelAccess access = ContainerLevelAccess.NULL;
    private IItemHandler internal;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;
    private Supplier<Boolean> boundItemMatcher = null;
    private Entity boundEntity = null;
    private BlockEntity boundBlockEntity = null;
    private int progress = 0;
    private int maxProgress = 200;
    private boolean isCooking = false;
    private boolean isLit = false;

    public BoilingCauldronInterfaceMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)ConcoctionModMenus.BOILING_CAULDRON_INTERFACE.get(), id);
        BlockEntity blockEntity;
        this.entity = inv.player;
        this.world = inv.player.level();
        this.internal = new ItemStackHandler(6);
        BlockPos pos = null;
        if (extraData != null) {
            pos = extraData.readBlockPos();
            this.x = pos.getX();
            this.y = pos.getY();
            this.z = pos.getZ();
            this.access = ContainerLevelAccess.create((Level)this.world, (BlockPos)pos);
        }
        if (pos != null && (blockEntity = this.world.getBlockEntity(pos)) instanceof CookingCauldronEntity) {
            CookingCauldronEntity cauldron = (CookingCauldronEntity)blockEntity;
            this.boundBlockEntity = cauldron;
            this.internal = new InvWrapper((Container)cauldron);
        }
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.customSlots.put(36, this.addSlot((Slot)new SlotItemHandler(this.internal, 0, 26, 27)));
        this.customSlots.put(37, this.addSlot((Slot)new SlotItemHandler(this.internal, 1, 44, 27)));
        this.customSlots.put(38, this.addSlot((Slot)new SlotItemHandler(this.internal, 2, 26, 45)));
        this.customSlots.put(39, this.addSlot((Slot)new SlotItemHandler(this.internal, 3, 44, 45)));
        this.customSlots.put(40, this.addSlot((Slot)new SlotItemHandler(this.internal, 4, 78, 15){

            public boolean mayPlace(ItemStack stack) {
                return BoilingCauldronInterfaceMenu.this.isValidLadleItem(stack);
            }
        }));
        this.customSlots.put(41, this.addSlot((Slot)new SlotItemHandler(this.internal, 5, 118, 38){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public boolean mayPickup(Player player) {
                BlockEntity blockEntity = BoilingCauldronInterfaceMenu.this.boundBlockEntity;
                if (blockEntity instanceof CookingCauldronEntity) {
                    CookingCauldronEntity cauldron = (CookingCauldronEntity)blockEntity;
                    return true;
                }
                return false;
            }

            public void onTake(Player player, ItemStack stack) {
                super.onTake(player, stack);
                BlockEntity blockEntity = BoilingCauldronInterfaceMenu.this.boundBlockEntity;
                if (blockEntity instanceof CookingCauldronEntity) {
                    CookingCauldronEntity cauldron = (CookingCauldronEntity)blockEntity;
                    Map<String, String> craftResult = cauldron.getCraftResult();
                    String interactionType = craftResult.get("interactionType");
                    cauldron.setCraftResult(Map.of("id", "", "count", "", "interactionType", ""));
                }
                if (!player.level().isClientSide() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Utils.addAchievement(serverPlayer, "concoction:cauldron_boiling");
                }
            }
        }));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    private boolean isValidLadleItem(ItemStack stack) {
        return stack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:tableware")));
    }

    public int getProgress() {
        BlockEntity blockEntity = this.boundBlockEntity;
        if (blockEntity instanceof CookingCauldronEntity) {
            CookingCauldronEntity entity = (CookingCauldronEntity)blockEntity;
            return entity.getProgress();
        }
        return this.progress;
    }

    public int getMaxProgress() {
        BlockEntity blockEntity = this.boundBlockEntity;
        if (blockEntity instanceof CookingCauldronEntity) {
            CookingCauldronEntity entity = (CookingCauldronEntity)blockEntity;
            return entity.getMaxProgress();
        }
        return this.maxProgress;
    }

    public boolean isCooking() {
        BlockEntity blockEntity = this.boundBlockEntity;
        if (blockEntity instanceof CookingCauldronEntity) {
            CookingCauldronEntity entity = (CookingCauldronEntity)blockEntity;
            return entity.isCooking();
        }
        return this.isCooking;
    }

    public boolean isLit() {
        BlockEntity blockEntity = this.boundBlockEntity;
        if (blockEntity instanceof CookingCauldronEntity) {
            CookingCauldronEntity entity = (CookingCauldronEntity)blockEntity;
            return entity.isLit();
        }
        return this.isLit;
    }

    public boolean stillValid(Player player) {
        if (this.bound) {
            if (this.boundItemMatcher != null) {
                return this.boundItemMatcher.get();
            }
            if (this.boundBlockEntity != null) {
                return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)this.boundBlockEntity.getBlockState().getBlock());
            }
            if (this.boundEntity != null) {
                return this.boundEntity.isAlive();
            }
        }
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            itemstack = stackInSlot.copy();
            if (index == 41) {
                if (!this.moveItemStackTo(stackInSlot, 0, 35, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onTake(playerIn, stackInSlot);
            } else if (index >= 0 && index <= 35) {
                Slot ladleSlot;
                boolean moved = false;
                if (this.isValidLadleItem(stackInSlot) && (ladleSlot = (Slot)this.slots.get(40)).mayPlace(stackInSlot)) {
                    int space;
                    int toMove;
                    ItemStack splitStack;
                    ItemStack ladleStack = ladleSlot.getItem();
                    if (ladleStack.isEmpty()) {
                        if (this.moveItemStackTo(stackInSlot, 40, 41, false)) {
                            moved = true;
                        }
                    } else if (ladleStack.getItem() == stackInSlot.getItem() && ladleStack.getCount() < ladleStack.getMaxStackSize() && this.moveItemStackTo(splitStack = stackInSlot.split(toMove = Math.min(space = ladleStack.getMaxStackSize() - ladleStack.getCount(), stackInSlot.getCount())), 40, 41, false)) {
                        moved = true;
                    }
                }
                if (!moved) {
                    for (int i = 36; i <= 39; ++i) {
                        int space;
                        int toMove;
                        ItemStack splitStack;
                        Slot ingredientSlot = (Slot)this.slots.get(i);
                        if (!ingredientSlot.mayPlace(stackInSlot)) continue;
                        ItemStack slotStack = ingredientSlot.getItem();
                        if (slotStack.isEmpty()) {
                            if (!this.moveItemStackTo(stackInSlot, i, i + 1, false)) continue;
                            moved = true;
                            break;
                        }
                        if (slotStack.getItem() != stackInSlot.getItem() || slotStack.getCount() >= slotStack.getMaxStackSize() || !this.moveItemStackTo(splitStack = stackInSlot.split(toMove = Math.min(space = slotStack.getMaxStackSize() - slotStack.getCount(), stackInSlot.getCount())), i, i + 1, false)) continue;
                        moved = true;
                        break;
                    }
                    if (!moved) {
                        return ItemStack.EMPTY;
                    }
                }
            } else if (index >= 36 && index <= 40 && !this.moveItemStackTo(stackInSlot, 0, 35, true)) {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stackInSlot.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, stackInSlot);
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }
}

