/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import java.util.Map;
import net.mcreator.concoction.ConcoctionMod;
import net.mcreator.concoction.block.entity.ButterChurnEntity;
import net.mcreator.concoction.init.ConcoctionModSounds;
import net.mcreator.concoction.interfaces.IPlayerUnsuccessfulAttempts;
import net.mcreator.concoction.utils.Utils;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ButterChurnBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    public static final BooleanProperty FULL = BooleanProperty.create((String)"full");

    public ButterChurnBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(2.5f).randomTicks().pushReaction(PushReaction.IGNORE));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)FULL, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ButterChurnEntity(pPos, pState);
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, FULL});
    }

    public ItemInteractionResult useItemOn(ItemStack pItem, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult p_316140_) {
        ButterChurnEntity butterChurn;
        if (pLevel.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockentity = pLevel.getBlockEntity(pPos);
        if (blockentity instanceof ButterChurnEntity) {
            ButterChurnEntity butterChurn2 = (ButterChurnEntity)blockentity;
            if (pItem.getItem() instanceof ShovelItem && !butterChurn2.hasCraftedResult() && butterChurn2.hasRecipe()) {
                if (pPlayer instanceof ServerPlayer) {
                    AdvancementProgress _ap;
                    ServerPlayer _player = (ServerPlayer)pPlayer;
                    AdvancementHolder _adv = _player.server.getAdvancements().get(ResourceLocation.parse((String)"concoction:you_spin_me_round"));
                    if (_adv != null && !(_ap = _player.getAdvancements().getOrStartProgress(_adv)).isDone()) {
                        for (String criteria : _ap.getRemainingCriteria()) {
                            _player.getAdvancements().award(_adv, criteria);
                        }
                    }
                }
                pLevel.playSound(null, pPos, (SoundEvent)ConcoctionModSounds.BUTTER_CHURN_SPIN.get(), SoundSource.BLOCKS, 1.0f, (float)Math.random() + 0.5f);
                IPlayerUnsuccessfulAttempts countPlayer = null;
                if (Math.random() < 0.2) {
                    countPlayer = (IPlayerUnsuccessfulAttempts)pPlayer;
                    countPlayer.concoction$setUnsuccessfulAttempts(0);
                    butterChurn2.craftItem();
                    pLevel.playSound(null, pPos, (SoundEvent)ConcoctionModSounds.BUTTER_THICKENS.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)FULL, (Comparable)Boolean.valueOf(true)));
                    butterChurn2.setChanged();
                    return ItemInteractionResult.SUCCESS;
                }
                if (pPlayer instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)pPlayer;
                    countPlayer = (IPlayerUnsuccessfulAttempts)player;
                    countPlayer.concoction$incrementUnsuccessfulAttempts();
                    if (countPlayer.concoction$getUnsuccessfulAttempts() >= 24) {
                        Utils.addAchievement(player, "concoction:unlucky_butter_churn");
                        countPlayer.concoction$setUnsuccessfulAttempts(0);
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        if (blockentity instanceof ButterChurnEntity && (butterChurn = (ButterChurnEntity)blockentity).hasCraftedResult()) {
            Map<String, String> result = butterChurn.getCraftResult();
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)result.get("id")));
            switch (result.get("interactionType")) {
                case "hand": {
                    if (!pItem.getItem().equals(Items.AIR) && (!pItem.getItem().equals(item) || pItem.getCount() >= pItem.getMaxStackSize())) break;
                    if (!pPlayer.addItem(new ItemStack((ItemLike)item))) {
                        pPlayer.drop(new ItemStack((ItemLike)item), false);
                    }
                    pLevel.playSound(null, pPos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, (float)Math.random());
                    result = this.decreesItemCountFromResult(result);
                    if (result.get("count").isEmpty()) {
                        pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)FULL, (Comparable)Boolean.valueOf(false)));
                        butterChurn.setChanged();
                    }
                    butterChurn.setCraftResult(result);
                    break;
                }
                case "bottle": {
                    if (!pItem.getItem().equals(Items.GLASS_BOTTLE)) break;
                    if (!pPlayer.addItem(new ItemStack((ItemLike)item))) {
                        pPlayer.drop(new ItemStack((ItemLike)item), false);
                    }
                    if (!pPlayer.isCreative()) {
                        pItem.shrink(1);
                    }
                    pLevel.playSound(null, pPos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, (float)Math.random() + 0.5f);
                    result = this.decreesItemCountFromResult(result);
                    if (result.get("count").isEmpty()) {
                        pLevel.setBlockAndUpdate(pPos, (BlockState)pState.setValue((Property)FULL, (Comparable)Boolean.valueOf(false)));
                        butterChurn.setChanged();
                    }
                    butterChurn.setCraftResult(result);
                    break;
                }
                default: {
                    ConcoctionMod.LOGGER.warn("Unknown interaction type: {}", (Object)butterChurn.getCraftResult().get("interactionType"));
                }
            }
            return ItemInteractionResult.CONSUME;
        }
        if (blockentity instanceof ButterChurnEntity) {
            ButterChurnEntity butter = (ButterChurnEntity)blockentity;
            if (pItem.getItem().equals(Items.AIR)) {
                if (pPlayer.addItem(butter.takeItemOnClick(true))) {
                    pLevel.playSound(null, pPos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, (float)Math.random());
                }
            } else if (butter.addItemOnClick(pItem, 1, pPlayer.isCreative())) {
                pLevel.playSound(null, pPos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, (float)Math.random());
            } else {
                pLevel.playSound(null, pPos, (SoundEvent)ConcoctionModSounds.BARREL_OVERFILLED.get(), SoundSource.BLOCKS, 1.0f, (float)Math.random());
            }
        }
        return ItemInteractionResult.CONSUME;
    }

    public Map<String, String> decreesItemCountFromResult(Map<String, String> result) {
        int new_count = Integer.parseInt(result.get("count")) - 1;
        if (new_count <= 0) {
            return Map.ofEntries(Map.entry("id", ""), Map.entry("count", ""), Map.entry("interactionType", ""));
        }
        return Map.ofEntries(Map.entry("id", result.get("id")), Map.entry("count", String.valueOf(new_count)), Map.entry("interactionType", result.get("interactionType")));
    }

    public void onRemove(BlockState p_54085_, Level p_54086_, BlockPos p_54087_, BlockState p_54088_, boolean p_54089_) {
        Containers.dropContentsOnDestroy((BlockState)p_54085_, (BlockState)p_54088_, (Level)p_54086_, (BlockPos)p_54087_);
        super.onRemove(p_54085_, p_54086_, p_54087_, p_54088_, p_54089_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> type) {
        return null;
    }

    public boolean hasAnalogOutputSignal(BlockState p_54055_) {
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite())).setValue((Property)FULL, (Comparable)Boolean.valueOf(false));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }
}

