/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import net.mcreator.concoction.init.ConcoctionModBlocks;
import net.mcreator.concoction.init.ConcoctionModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class CropCabbageBlock
extends CropBlock {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)3);

    public CropCabbageBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).sound(SoundType.GRASS).instabreak().noCollission().noOcclusion().randomTicks().pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void randomTick(BlockState pLevel, ServerLevel p_221051_, BlockPos p_221052_, RandomSource randomSource) {
        float f;
        int i;
        if (!p_221051_.isAreaLoaded(p_221052_, 1)) {
            return;
        }
        if (p_221051_.getRawBrightness(p_221052_, 0) >= 9 && (i = this.getAge(pLevel)) < this.getMaxAge() && CommonHooks.canCropGrow((Level)p_221051_, (BlockPos)p_221052_, (BlockState)pLevel, (randomSource.nextInt((int)(25.0f / (f = CropCabbageBlock.getGrowthSpeed((BlockState)pLevel, (BlockGetter)p_221051_, (BlockPos)p_221052_))) + 1) == 0 ? 1 : 0) != 0)) {
            if (i + 1 == this.getMaxAge() && randomSource.nextFloat() <= 0.06f) {
                p_221051_.setBlock(p_221052_, ((Block)ConcoctionModBlocks.CABBAGE_BLOCK.get()).defaultBlockState(), 2);
            } else {
                p_221051_.setBlock(p_221052_, this.getStateForAge(i + 1), 2);
            }
            if (randomSource.nextFloat() <= 0.001f) {
                BlockPos offsetPos = p_221052_.offset(-1, 0, -1);
                boolean spaceAvailable = true;
                block0: for (int dx = -1; dx < 3; ++dx) {
                    for (int dy = 0; dy < 3; ++dy) {
                        for (int dz = -1; dz < 3; ++dz) {
                            BlockPos checkPos = offsetPos.offset(dx, dy, dz);
                            BlockState state = p_221051_.getBlockState(checkPos);
                            if (state.isAir() || !state.isCollisionShapeFullBlock((BlockGetter)p_221051_, checkPos)) continue;
                            spaceAvailable = false;
                            break block0;
                        }
                    }
                }
                if (spaceAvailable && p_221051_ instanceof ServerLevel) {
                    ServerLevel _serverworld = p_221051_;
                    ResourceLocation structureResource = ResourceLocation.tryParse((String)"concoction:giant_cabbage");
                    StructureTemplate template = _serverworld.getStructureManager().getOrCreate(structureResource);
                    if (template != null) {
                        template.placeInWorld((ServerLevelAccessor)_serverworld, offsetPos, offsetPos, new StructurePlaceSettings().setRotation(Rotation.NONE).setMirror(Mirror.NONE).setIgnoreEntities(false), _serverworld.random, 3);
                    }
                }
            }
            CommonHooks.fireCropGrowPost((Level)p_221051_, (BlockPos)p_221052_, (BlockState)pLevel);
        }
    }

    public void growCrops(Level pLevel, BlockPos pPos, BlockState p_52266_) {
        int j;
        int i = this.getAge(p_52266_) + this.getBonemealAgeIncrease(pLevel);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        if (i == this.getMaxAge() && RandomSource.create().nextFloat() <= 0.01f) {
            pLevel.setBlock(pPos, ((Block)ConcoctionModBlocks.CABBAGE_BLOCK.get()).defaultBlockState(), 2);
        } else {
            pLevel.setBlock(pPos, this.getStateForAge(i), 2);
        }
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)AGE)) {
            default -> Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
            case 0 -> Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
            case 1 -> Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
            case 2 -> Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
            case 3 -> Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ConcoctionModItems.CABBAGE_SEEDS.get());
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 25;
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.OPEN;
    }

    public int getMaxAge() {
        return 3;
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)ConcoctionModItems.CABBAGE_SEEDS.get();
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }
}

