/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import net.mcreator.concoction.block.MintBlock;
import net.mcreator.concoction.init.ConcoctionModBlocks;
import net.mcreator.concoction.init.ConcoctionModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class CropMintBlock
extends CropBlock {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)3);
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0)};

    public CropMintBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).sound(SoundType.GRASS).strength(0.0f, 1.0f).noCollission().noOcclusion().randomTicks().pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BY_AGE[this.getAge(pState)];
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource random) {
        if (!pLevel.isAreaLoaded(pPos, 1)) {
            return;
        }
        if (pLevel.getRawBrightness(pPos, 0) >= 9) {
            float f;
            int nextAge = this.getAge(pState) + 1;
            if (nextAge == this.getMaxAge() && pLevel.getBlockState(pPos.above(1)).is(Blocks.AIR)) {
                pLevel.setBlock(pPos, ((Block)ConcoctionModBlocks.MINT.get()).defaultBlockState(), 2);
                pLevel.setBlock(pPos.above(1), (BlockState)((Block)ConcoctionModBlocks.MINT.get()).defaultBlockState().setValue((Property)MintBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
            } else if (nextAge < this.getMaxAge() && CommonHooks.canCropGrow((Level)pLevel, (BlockPos)pPos, (BlockState)pState, (random.nextInt((int)(25.0f / (f = CropMintBlock.getGrowthSpeed((BlockState)pState, (BlockGetter)pLevel, (BlockPos)pPos))) + 1) == 0 ? 1 : 0) != 0)) {
                pLevel.setBlock(pPos, this.getStateForAge(nextAge), 2);
                CommonHooks.fireCropGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
            }
        }
    }

    public void growCrops(Level pLevel, BlockPos pPos, BlockState pState) {
        int maxAge;
        int nextAge = this.getAge(pState) + this.getBonemealAgeIncrease(pLevel);
        if (nextAge > (maxAge = this.getMaxAge())) {
            nextAge = maxAge;
        }
        if (nextAge == maxAge && pLevel.getBlockState(pPos.above(1)).is(Blocks.AIR)) {
            pLevel.setBlock(pPos, ((Block)ConcoctionModBlocks.MINT.get()).defaultBlockState(), 2);
            pLevel.setBlock(pPos.above(1), (BlockState)((Block)ConcoctionModBlocks.MINT.get()).defaultBlockState().setValue((Property)MintBlock.HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
        } else {
            pLevel.setBlock(pPos, this.getStateForAge(nextAge), 2);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 25;
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.OPEN;
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity == null ? false : blockEntity.triggerEvent(eventID, eventParam);
    }

    public int getMaxAge() {
        return 3;
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)ConcoctionModItems.MINT_SEEDS.get();
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }
}

