/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import net.mcreator.concoction.init.ConcoctionModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CropOnionBlock
extends CropBlock {
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)3);

    public CropOnionBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).sound(SoundType.GRASS).instabreak().noCollission().noOcclusion().randomTicks().pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)AGE)) {
            default -> Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
            case 0 -> Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);
            case 1 -> Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
            case 2 -> Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0);
            case 3 -> Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ConcoctionModItems.ONION.get());
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 25;
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.OPEN;
    }

    protected ItemInteractionResult useItemOn(ItemStack pItem, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand p_316595_, BlockHitResult p_316140_) {
        if (!pPlayer.isShiftKeyDown() && (Integer)pState.getValue((Property)AGE) == 3 && pPlayer.getMainHandItem().getItem() == Items.SHEARS) {
            if (pLevel instanceof ServerLevel) {
                ServerLevel _level = (ServerLevel)pLevel;
                if (!pPlayer.isCreative()) {
                    pItem.hurtAndBreak(1, (LivingEntity)pPlayer, pPlayer.getEquipmentSlotForItem(pItem));
                }
                pLevel.setBlock(pPos, this.defaultBlockState(), 2);
                if (!_level.isClientSide()) {
                    _level.playSound(null, pPos, SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(pPos, SoundEvents.SHEEP_SHEAR, SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
                ItemEntity entityToSpawn = new ItemEntity((Level)_level, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, new ItemStack((ItemLike)ConcoctionModItems.GREEN_ONION.get(), 1));
                entityToSpawn.setPickUpDelay(10);
                _level.addFreshEntity((Entity)entityToSpawn);
                if (Math.random() < 0.5) {
                    ItemEntity AdditEntityToSpawn = new ItemEntity((Level)_level, (double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, new ItemStack((ItemLike)ConcoctionModItems.GREEN_ONION.get()));
                    AdditEntityToSpawn.setPickUpDelay(10);
                    _level.addFreshEntity((Entity)AdditEntityToSpawn);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(pItem, pState, pLevel, pPos, pPlayer, p_316595_, p_316140_);
    }

    public int getMaxAge() {
        return 3;
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)ConcoctionModItems.ONION.get();
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }
}

