/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block;

import net.mcreator.concoction.block.SoullandBlock;
import net.mcreator.concoction.init.ConcoctionModEntities;
import net.mcreator.concoction.init.ConcoctionModItems;
import net.mcreator.concoction.init.ConcoctionModParticleTypes;
import net.mcreator.concoction.utils.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.CaveSpider;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CropPuffballBlock
extends CropBlock {
    public static final int MAX_AGE = 2;
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)2);

    public CropPuffballBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.CLAY).sound(SoundType.GRASS).instabreak().noCollission().noOcclusion().randomTicks().pushReaction(PushReaction.DESTROY).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Integer)state.getValue((Property)AGE)) {
            default -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
            case 0 -> Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
            case 1 -> Block.box((double)6.0, (double)1.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
            case 2 -> Block.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)7.0, (double)12.0);
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ConcoctionModItems.PUFFBALL_SPORES.get());
    }

    public boolean mayPlaceOn(BlockState state, BlockGetter worldIn, BlockPos pos) {
        if (!(worldIn instanceof LevelReader)) {
            return false;
        }
        return this.canSurvive(state, (LevelReader)worldIn, pos);
    }

    protected boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockBelow = pos.below();
        BlockState soil = worldIn.getBlockState(blockBelow);
        return soil.isSolidRender((BlockGetter)worldIn, blockBelow) || soil.getBlock() instanceof FarmBlock || soil.getBlock() instanceof SoullandBlock;
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.OPEN;
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)ConcoctionModItems.PUFFBALL_SPORES.get();
    }

    public int getMaxAge() {
        return 2;
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (!world.isClientSide && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            int age = (Integer)state.getValue((Property)AGE);
            if (age == 2 && !livingEntity.isCrouching()) {
                EntityType replacementType;
                LivingEntity newEntity;
                if ((entity instanceof Spider || entity instanceof CaveSpider) && entity.getType() != ConcoctionModEntities.CORDYCEPS_SPIDER.get() && entity.getType() != ConcoctionModEntities.CORDYCEPS_CAVE_SPIDER.get() && (newEntity = (LivingEntity)(replacementType = entity instanceof CaveSpider ? (EntityType)ConcoctionModEntities.CORDYCEPS_CAVE_SPIDER.get() : (EntityType)ConcoctionModEntities.CORDYCEPS_SPIDER.get()).create(world)) != null) {
                    newEntity.moveTo(entity.getX(), entity.getY(), entity.getZ(), entity.getYRot(), entity.getXRot());
                    newEntity.setYRot(entity.getYRot());
                    newEntity.setXRot(entity.getXRot());
                    if (entity instanceof LivingEntity) {
                        LivingEntity le = (LivingEntity)entity;
                        newEntity.setYHeadRot(le.getYHeadRot());
                        newEntity.setXRot(le.getXRot());
                    }
                    newEntity.setHealth(((LivingEntity)entity).getHealth());
                    newEntity.setCustomName(entity.getCustomName());
                    newEntity.setCustomNameVisible(entity.isCustomNameVisible());
                    if (newEntity instanceof Mob) {
                        Mob mobEntity = (Mob)newEntity;
                        mobEntity.setPersistenceRequired();
                    }
                    for (MobEffectInstance effect : ((LivingEntity)entity).getActiveEffects()) {
                        newEntity.addEffect(new MobEffectInstance(effect));
                    }
                    world.addFreshEntity((Entity)newEntity);
                    entity.discard();
                    entity = newEntity;
                    livingEntity = newEntity;
                }
                livingEntity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 40, 0));
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    Utils.addAchievement(serverPlayer, "concoction:puffball_accident");
                }
                world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age - 2)), 3);
                world.playSound(null, pos, SoundEvents.CROP_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (world instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)world;
                    serverWorld.sendParticles((ParticleOptions)((SimpleParticleType)ConcoctionModParticleTypes.SPORE_CLOUD.get()), (double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5, 10, 0.5, 0.5, 0.5, 0.01);
                }
                RandomSource random = world.getRandom();
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                for (int i = 0; i < 20; ++i) {
                    int dx = random.nextInt(9) - 4;
                    int dy = random.nextInt(3) - 1;
                    int dz = random.nextInt(9) - 4;
                    mutablePos.set(pos.getX() + dx, pos.getY() + dy, pos.getZ() + dz);
                    BlockState targetState = world.getBlockState((BlockPos)mutablePos);
                    if (!targetState.isAir() || !this.canSurvive((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0)), (LevelReader)world, (BlockPos)mutablePos)) continue;
                    world.setBlock((BlockPos)mutablePos, (BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0)), 3);
                    if (!(world instanceof ServerLevel)) continue;
                    ServerLevel serverWorld2 = (ServerLevel)world;
                    serverWorld2.sendParticles((ParticleOptions)((SimpleParticleType)ConcoctionModParticleTypes.SPORE_CLOUD.get()), (double)mutablePos.getX() + 0.5, (double)mutablePos.getY() + 1.0, (double)mutablePos.getZ() + 0.5, 5, 0.3, 0.3, 0.3, 0.01);
                }
            }
        }
        super.entityInside(state, world, pos, entity);
    }
}

