/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.block.entity;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.mcreator.concoction.init.ConcoctionModBlockEntities;
import net.mcreator.concoction.init.ConcoctionModRecipes;
import net.mcreator.concoction.recipe.butterChurn.ButterChurnRecipe;
import net.mcreator.concoction.recipe.butterChurn.ButterChurnRecipeInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ButterChurnEntity
extends RandomizableContainerBlockEntity {
    private final int ContainerSize = 1;
    private RecipeHolder<ButterChurnRecipe> recipe = null;
    private Map<String, String> craftResult = Map.ofEntries(Map.entry("id", ""), Map.entry("count", ""), Map.entry("interactionType", ""));
    private NonNullList<ItemStack> items = NonNullList.withSize((int)this.ContainerSize, (Object)ItemStack.EMPTY);

    public ButterChurnEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ConcoctionModBlockEntities.BUTTER_CHURN.get(), pos, state);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        this.craftResult = (Map)new Gson().fromJson(tag.getString("churn.craft_result"), HashMap.class);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("churn.craft_result", new Gson().toJson(this.craftResult));
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    public int getContainerSize() {
        return this.ContainerSize;
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public void setItem(int slot, ItemStack stack) {
        stack.limitSize(Math.min(this.getMaxStackSize(stack), 8));
        this.items.set(slot, (Object)stack);
        this.setChanged();
    }

    protected void setItems(NonNullList<ItemStack> Items2) {
        this.items = Items2;
        this.setChanged();
    }

    public boolean addItemOnClick(ItemStack addedItem, int count, boolean isCreative) {
        boolean flag = false;
        ItemStack itemstack = this.getItem(0);
        if (itemstack.isEmpty()) {
            this.setItem(0, isCreative ? addedItem.copyWithCount(1) : addedItem.split(count));
            flag = true;
        } else if (ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)addedItem) && itemstack.getCount() < 8) {
            int to_add = Math.min(count, 8 - itemstack.getCount());
            itemstack.grow(to_add);
            if (!isCreative) {
                addedItem.shrink(to_add);
            }
            flag = true;
        }
        return flag;
    }

    public ItemStack takeItemOnClick(boolean takeAll) {
        ItemStack returnStack = ItemStack.EMPTY;
        ItemStack itemstack = (ItemStack)this.items.get(0);
        if (!itemstack.isEmpty()) {
            if (takeAll) {
                returnStack = itemstack.copy();
                this.setItem(0, ItemStack.EMPTY);
            } else {
                returnStack = itemstack.split(1);
            }
            this.setChanged();
            return returnStack;
        }
        return returnStack;
    }

    public void craftItem() {
        NonNullList<ItemStack> returned_items = this.checkReturnedItems();
        this.clearContent();
        if (!returned_items.stream().allMatch(ItemStack::isEmpty)) {
            this.setItems(returned_items);
        }
        this.craftResult = ((ButterChurnRecipe)this.recipe.value()).getOutput();
    }

    private NonNullList<ItemStack> checkReturnedItems() {
        Item remainder;
        NonNullList returned_items = NonNullList.withSize((int)this.ContainerSize, (Object)ItemStack.EMPTY);
        ItemStack itemstack = (ItemStack)this.items.getFirst();
        if (itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:buckets")))) {
            returned_items.set(0, (Object)new ItemStack((ItemLike)Items.BUCKET, itemstack.getCount()));
        } else if (itemstack.is(ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:bottles")))) {
            returned_items.set(0, (Object)new ItemStack((ItemLike)Items.GLASS_BOTTLE, itemstack.getCount()));
        } else if (itemstack.getItem().hasCraftingRemainingItem() && (remainder = itemstack.getItem().getCraftingRemainingItem()) != null) {
            ItemStack returnedItem = new ItemStack((ItemLike)remainder, itemstack.getCount());
            returned_items.set(0, (Object)returnedItem);
        }
        return returned_items;
    }

    public boolean hasCraftedResult() {
        return !this.craftResult.get("id").isEmpty();
    }

    public Map<String, String> getCraftResult() {
        return this.craftResult;
    }

    public void setCraftResult(Map<String, String> result) {
        this.craftResult = result;
        this.setChanged();
    }

    public boolean hasRecipe() {
        Optional<RecipeHolder<ButterChurnRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        this.recipe = recipe.get();
        return true;
    }

    private Optional<RecipeHolder<ButterChurnRecipe>> getCurrentRecipe() {
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ConcoctionModRecipes.BUTTER_CHURN_RECIPE_TYPE.get(), (RecipeInput)new ButterChurnRecipeInput(this.getBlockState(), this.getItems()), this.level);
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        this.items.clear();
        this.setChanged();
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        super.onDataPacket(connection, packet, registries);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.handleUpdateTag(tag, registries);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.butter_churn");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return null;
    }

    protected AbstractContainerMenu createMenu(int p_58627_, Inventory p_58628_) {
        return null;
    }
}

