/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.concoction.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import net.mcreator.concoction.world.inventory.BoilingCauldronInterfaceMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;

public class BoilingCauldronInterfaceScreen
extends AbstractContainerScreen<BoilingCauldronInterfaceMenu> {
    private static final HashMap<String, Object> guistate = BoilingCauldronInterfaceMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"concoction:textures/gui/hud/cooking_cauldron_gui_playerside.png");

    public BoilingCauldronInterfaceScreen(BoilingCauldronInterfaceMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
        this.inventoryLabelY = 74;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fillGradient(0, 0, this.width, this.height, 0x33000000, 0x33000000);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        if (((BoilingCauldronInterfaceMenu)this.menu).isCooking()) {
            int progress = ((BoilingCauldronInterfaceMenu)this.menu).getProgress();
            int maxProgress = ((BoilingCauldronInterfaceMenu)this.menu).getMaxProgress();
            int progressSize = 44 * progress / maxProgress;
            guiGraphics.blit(texture, this.leftPos + 65, this.topPos + 34, 176.0f, 0.0f, progressSize, 24, 256, 256);
        }
        if (((BoilingCauldronInterfaceMenu)this.menu).isLit()) {
            guiGraphics.blit(texture, this.leftPos + 79, this.topPos + 61, 176.0f, 24.0f, 14, 14, 256, 256);
        }
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int titleWidth = this.font.width(this.title.getString());
        int titleX = (this.imageWidth - titleWidth) / 2;
        guiGraphics.drawString(this.font, this.title, titleX, 6, 0x404040, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"container.inventory"), 8, 72, 0x404040, false);
    }

    public void init() {
        super.init();
    }
}

